/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.plugin.descriptor.LayoutModuleDescriptor;
import com.atlassian.confluence.themes.ThemedDecorator;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import org.apache.log4j.Category;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class VelocityDecorator
implements ThemedDecorator {
    private static final Category log = Category.getInstance(VelocityDecorator.class);
    private String templatePath;
    private String name;
    private String moduleCompleteKey;

    public Decorator getDecorator(Decorator parentDecorator) {
        try {
            VelocityManager.getInstance().getVelocityEngine().getTemplate(this.templatePath);
            return new DefaultDecorator(parentDecorator.getName(), this.templatePath, null);
        }
        catch (ResourceNotFoundException e) {
            log.error((Object)("Layout module could not find velocity template:" + this.templatePath), (Throwable)e);
        }
        catch (ParseErrorException e) {
            log.error((Object)("Error parsing decorator template:" + this.templatePath), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving space decorator:" + this.templatePath), (Throwable)e);
        }
        return null;
    }

    public void init(LayoutModuleDescriptor moduleDescriptor) {
        this.templatePath = moduleDescriptor.getResourceDescriptor("velocity", "decorator").getLocation();
        this.name = moduleDescriptor.getDecoratorPath();
        this.moduleCompleteKey = moduleDescriptor.getCompleteKey();
    }

    public String getResourceKey() {
        return this.moduleCompleteKey;
    }

    public String getVelocityTemplatePath() {
        return this.templatePath;
    }

    public String getName() {
        return this.name;
    }
}

