/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.core.util.FileUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class AttachmentFileNameUpgradeTask
implements UpgradeTask {
    public static final int UPDATE_BUILD_NUMBER = 501;
    private static final String UPDATE_BUILD_NUMBER_STR = String.valueOf(501);
    private static final String STAGING_DIR_NAME = "AttachmentFileNameUpgradeTask";
    protected static Category log = Category.getInstance(AttachmentFileNameUpgradeTask.class);
    private List errors = new LinkedList();
    private AttachmentDao attachmentDao;
    private BootstrapManager bootstrap = (BootstrapManager)BootstrapUtils.getBootstrapManager();
    private boolean searchForMissingAttachmentFiles = true;
    private File attachmentDir;
    private File stagingDir;
    public String[] mangledEncodings = new String[]{"ISO-8859-1", "US-ASCII"};

    public boolean isSearchForMissingAttachmentFiles() {
        return this.searchForMissingAttachmentFiles;
    }

    public void setSearchForMissingAttachmentFiles(boolean searchForMissingAttachmentFiles) {
        this.searchForMissingAttachmentFiles = searchForMissingAttachmentFiles;
    }

    public void setBootstrap(BootstrapManager bootstrap) {
        this.bootstrap = bootstrap;
    }

    public String[] getMangledEncodings() {
        return this.mangledEncodings;
    }

    public void setMangledEncodings(String[] mangledEncodings) {
        this.mangledEncodings = mangledEncodings;
    }

    public String getBuildNumber() {
        return UPDATE_BUILD_NUMBER_STR;
    }

    public String getShortDescription() {
        return "Upgrade file system stored attachments to use attachment id as file name";
    }

    public void doUpgrade() throws Exception {
        if (this.bootstrap.isWebdavEnabled()) {
            return;
        }
        this.attachmentDir = new File(this.bootstrap.getFilePathProperty("attachments.dir") + "/");
        if (log.isDebugEnabled()) {
            this.debugPreamble();
        }
        this.stagingDir = new File(this.bootstrap.getFilePathProperty("webwork.multipart.saveDir") + "/" + STAGING_DIR_NAME);
        Iterator attachmentIterator = this.attachmentDao.findLatestVersionsIterator();
        LinkedList missingAttachments = new LinkedList();
        this.processAttachments(attachmentIterator, missingAttachments);
        this.processMissingAttachments(missingAttachments);
        this.processStagedUpdates();
        this.logMissingAttachments(missingAttachments);
    }

    protected void processAttachments(Iterator attachmentIterator, Collection missingAttachments) {
        log.info((Object)"Updating attachment file names");
        while (attachmentIterator.hasNext()) {
            Attachment attachment = (Attachment)attachmentIterator.next();
            ContentEntityObject content = attachment.getContent();
            File contentAttachmentDirectory = new File(this.attachmentDir, String.valueOf(content.getId()));
            if (!contentAttachmentDirectory.exists()) {
                if (!log.isEnabledFor(Priority.WARN)) continue;
                log.warn((Object)("Could not find attachment directory for " + content));
                continue;
            }
            File attachmentFile = new File(contentAttachmentDirectory, attachment.getFileName());
            if (!attachmentFile.getParentFile().equals(contentAttachmentDirectory)) {
                if (!log.isEnabledFor(Priority.WARN)) continue;
                log.warn((Object)("Bad attachment file name " + attachmentFile.getAbsolutePath() + " for attachment " + attachment));
                continue;
            }
            if (this.updateAttachmentFile(attachment, attachmentFile)) continue;
            missingAttachments.add(attachment);
        }
    }

    protected void processMissingAttachments(Collection missingAttachments) {
        if (missingAttachments.isEmpty() || !this.isSearchForMissingAttachmentFiles()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Running mangled file name detection for " + missingAttachments.size() + " missing attachment files"));
        }
        String fileEncoding = System.getProperty("file.encoding");
        log.info((Object)("Virtual machine running with " + fileEncoding + " encoding as default"));
        Iterator missingAttachmentsIterator = missingAttachments.iterator();
        while (missingAttachmentsIterator.hasNext()) {
            Attachment attachment = (Attachment)missingAttachmentsIterator.next();
            if (!this.tryToFixFile(this.attachmentDir, attachment, fileEncoding)) continue;
            missingAttachmentsIterator.remove();
        }
    }

    protected void logMissingAttachments(Collection missingAttachments) {
        if (missingAttachments.isEmpty()) {
            return;
        }
        log.error((Object)("Cound not update " + missingAttachments.size() + " attachment files"));
        for (Attachment missingAttachment : missingAttachments) {
            log.error((Object)("Missing attachment [id: " + missingAttachment.getId() + ", path:" + this.getExpectedAttachmentFile(missingAttachment) + "]"));
        }
    }

    protected boolean updateAttachmentFile(Attachment attachment, File attachmentFile) {
        if (!attachmentFile.exists()) {
            return false;
        }
        File updatedFile = new File(attachmentFile.getParentFile(), String.valueOf(attachment.getId()));
        if (updatedFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attachment file name collision detected. [" + attachmentFile + " -> " + updatedFile + "] - Staging update."));
            }
            this.stageUpdatedAttachment(attachmentFile, updatedFile);
            return true;
        }
        return attachmentFile.renameTo(updatedFile);
    }

    protected void stageUpdatedAttachment(File originalAttachment, File updatedFile) {
        File contentStaging = new File(this.stagingDir, originalAttachment.getParentFile().getName());
        contentStaging.mkdirs();
        File stagedUpdate = new File(contentStaging, updatedFile.getName());
        originalAttachment.renameTo(stagedUpdate);
    }

    protected void processStagedUpdates() {
        File[] stagedContents = this.stagingDir.listFiles();
        boolean processingError = false;
        if (stagedContents == null) {
            return;
        }
        log.info((Object)"Processing staged updates");
        File attachmentDirectory = new File(this.bootstrap.getFilePathProperty("attachments.dir") + "/");
        for (int x = 0; x < stagedContents.length; ++x) {
            File currentContent = stagedContents[x];
            File destinationContent = new File(attachmentDirectory, currentContent.getName());
            File[] attachmentFiles = currentContent.listFiles();
            for (int y = 0; y < attachmentFiles.length; ++y) {
                File stagedAttachment = attachmentFiles[y];
                File updatedAttachment = new File(destinationContent, stagedAttachment.getName());
                log.info((Object)("renaming " + stagedAttachment + " to " + updatedAttachment));
                if (stagedAttachment.renameTo(updatedAttachment)) continue;
                log.error((Object)("Failed to process staged updated: " + stagedAttachment));
                processingError = true;
            }
        }
        if (!processingError) {
            FileUtils.deleteDir((File)this.stagingDir);
        }
    }

    protected boolean tryToFixFile(File attachmentDir, Attachment attachment, String nativeEncoding) {
        for (int x = 0; x < this.mangledEncodings.length; ++x) {
            try {
                if (!this.tryToFixFile(attachmentDir, attachment, nativeEncoding, this.mangledEncodings[x])) continue;
                log.info((Object)("Detected " + nativeEncoding + " attachment file name encoded as " + this.mangledEncodings[x]));
                return true;
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"An encoding is unsupported", (Throwable)e);
            }
        }
        return false;
    }

    protected boolean tryToFixFile(File attachmentDir, Attachment attachment, String nativeEncoding, String fileSystemEncoding) throws UnsupportedEncodingException {
        File contentDir = new File(attachmentDir, String.valueOf(String.valueOf(attachment.getContent().getId())));
        String fileName = attachment.getFileName();
        String mangledName = new String(fileName.getBytes(nativeEncoding), fileSystemEncoding);
        File mangledFile = new File(contentDir, mangledName);
        return this.updateAttachmentFile(attachment, mangledFile);
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setAttachmentDao(AttachmentDao attachmentDao) {
        this.attachmentDao = attachmentDao;
    }

    private File getExpectedAttachmentFile(Attachment attachment) {
        File contentDir = new File(this.attachmentDir, String.valueOf(attachment.getContent().getId()));
        File attachmentFile = new File(contentDir, attachment.getFileName());
        return attachmentFile;
    }

    private void debugPreamble() {
        StringWriter strWriter = new StringWriter();
        PrintWriter printer = new PrintWriter((Writer)strWriter, true);
        printer.println();
        printer.println("System property user.dir: " + System.getProperty("user.dir"));
        printer.println("Attachments directory configured as: " + this.bootstrap.getFilePathProperty("attachments.dir"));
        printer.println("Attachment file object name: " + this.attachmentDir.getName());
        printer.println("Attachment path is absolute: " + this.attachmentDir.isAbsolute());
        printer.println("Attachment directory resolves to: " + this.attachmentDir.getAbsolutePath());
        log.debug((Object)strWriter.getBuffer());
    }
}

