/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class AttachmentsFileSizeUpgradeTask
implements UpgradeTask {
    private List errors = new ArrayList();
    private Category log = Category.getInstance(AttachmentsFileSizeUpgradeTask.class);
    private AttachmentManager attachmentManager;

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String getBuildNumber() {
        return "101";
    }

    public String getShortDescription() {
        return "Fix attachment file sizes";
    }

    public void doUpgrade() throws Exception {
        if (BootstrapUtils.getBootstrapManager().isWebdavEnabled()) {
            return;
        }
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        List attachments = session.find("from Attachment attachment");
        Iterator iterator = attachments.iterator();
        while (iterator.hasNext()) {
            this.fixAttachment((Attachment)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixAttachment(Attachment attachment) {
        InputStream inputStream;
        block4: {
            inputStream = null;
            try {
                inputStream = this.attachmentManager.getAttachmentData(attachment);
                int availableBytes = inputStream.available();
                if (attachment.getFileSize() == (long)availableBytes) break block4;
                this.log.warn((Object)(attachment.getFileName() + " version " + attachment.getVersion() + " changing file size from " + attachment.getFileSize() + " to " + availableBytes));
                attachment.setFileSize(availableBytes);
            }
            catch (Throwable e) {
                try {
                    this.log.error((Object)("Could not fix file size of attachment " + attachment), e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(inputStream);
                    throw throwable;
                }
                IOUtils.close(inputStream);
            }
        }
        IOUtils.close(inputStream);
    }

    public Collection getErrors() {
        return this.errors;
    }
}

