/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.GlobalDescription;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.Resource;
import com.atlassian.confluence.util.ResourceManager;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import com.atlassian.xwork.FileUploadUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public class ChangeLogoStorageUpgradeTask
implements DatabaseUpgradeTask {
    public static final String LOGO_KEY = "logo";
    private final SettingsManager settingsManager;
    private final ResourceManager resourceManager;
    private final FileUploadManager fileUploadManager;
    private final BootstrapManager bootstrapManager;
    private final SpaceManager spaceManager;

    public ChangeLogoStorageUpgradeTask(SettingsManager settingsManager, ResourceManager resourceManager, FileUploadManager fileUploadManager, BootstrapManager bootstrapManager, SpaceManager spaceManager) {
        this.settingsManager = settingsManager;
        this.resourceManager = resourceManager;
        this.fileUploadManager = fileUploadManager;
        this.bootstrapManager = bootstrapManager;
        this.spaceManager = spaceManager;
    }

    public void doNonDatabaseUpgrade() {
    }

    public void doUpgrade() throws Exception {
        if (this.settingsManager.getGlobalDescription() == null) {
            this.settingsManager.updateGlobalDescription(new GlobalDescription());
        }
        this.migrateGlobalLogo();
        this.migrateSpaceLogos();
    }

    private void migrateSpaceLogos() {
        for (Space space : this.spaceManager.getAllSpaces()) {
            Resource spaceLogo = this.resourceManager.getResource(LOGO_KEY, space);
            if (spaceLogo == null) continue;
            this.attachResource(spaceLogo, space.getDescription(), this.getSpaceLogoFileUsingRelativePath(spaceLogo.getRelativePathToFile(), space.getKey()), space.getKey());
            this.resourceManager.removeResource(LOGO_KEY, space);
        }
    }

    private void attachResource(Resource logo, ContentEntityObject ceo, File resourceFile, String attachmentName) {
        this.fileUploadManager.storeFile(new FileUploadUtils.UploadedFile(resourceFile, attachmentName, this.getContentType(logo)), "", ceo);
    }

    private String getContentType(Resource logo) {
        if (logo.getContentTypePrefix() != null) {
            int startIdx = logo.getRelativePathToFile().lastIndexOf(".");
            String ext = logo.getRelativePathToFile().substring(startIdx + 1);
            return logo.getContentTypePrefix() + "/" + ext;
        }
        return null;
    }

    private void migrateGlobalLogo() {
        Resource globalLogo = this.resourceManager.getResource(LOGO_KEY, null);
        if (globalLogo != null) {
            this.attachResource(globalLogo, this.settingsManager.getGlobalDescription(), this.getGlobalLogoFileUsingRelativePath(globalLogo.getRelativePathToFile()), "global.logo");
            this.resourceManager.removeResource(LOGO_KEY, null);
        }
    }

    private File getGlobalLogoFileUsingRelativePath(String relativePathToFile) {
        return new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources" + File.separator + relativePathToFile);
    }

    private File getSpaceLogoFileUsingRelativePath(String relativePathToFile, String spaceKey) {
        return new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources" + File.separator + spaceKey + File.separator + relativePathToFile);
    }

    public String getBuildNumber() {
        return "1404";
    }

    public Collection getErrors() {
        return Collections.emptyList();
    }

    public String getShortDescription() {
        return "migrates custom logos, creates the only global ceo";
    }
}

