/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class CommentParentColumnUpgradeTask
implements UpgradeTask {
    private List errors = new ArrayList();
    private Category log = Category.getInstance(CommentParentColumnUpgradeTask.class);
    private BootstrapManager bootstrapManager;
    private SessionFactory sessionFactory;
    private static final String CONFIG_FLAG_DONE = "upgradetask.CommentParentColumnUpgradeTask";

    public String getBuildNumber() {
        return "109";
    }

    public String getShortDescription() {
        return "Fix comment parent columns";
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void doUpgrade() throws Exception {
        if (this.bootstrapManager.isPropertyTrue(CONFIG_FLAG_DONE)) {
            this.log.info((Object)"Skipping upgrade task: already done");
            return;
        }
        this.log.info((Object)"Starting comment parent column upgrade task");
        Session session = null;
        session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        if (((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("PostgreSQLDialect")) {
            this.updateSchema(session);
        }
        this.updateContentTable(session);
        this.log.info((Object)"Comment parent column upgrade task complete.");
        this.bootstrapManager.setProperty(CONFIG_FLAG_DONE, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContentTable(Session session) throws HibernateException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("update CONTENT set PARENTCOMMENTID = PARENTID where CONTENTTYPE = 'COMMENT'");
                statement.execute("update CONTENT set PARENTID = null WHERE CONTENTTYPE = 'COMMENT'");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    this.log.error((Object)("Unable to add PARENTCOMMENTID column to CONTENT table: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.closeStatementQuietly(statement);
                    throw throwable;
                }
                SQLUtils.closeStatementQuietly(statement);
            }
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("alter table CONTENT add column PARENTCOMMENTID BIGINT");
                statement.execute("alter table CONTENT add constraint FK6382C059B97E9230 foreign key (PARENTCOMMENTID) references CONTENT");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    this.log.error((Object)("Unable to add PARENTCOMMENTID column to CONTENT table: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.closeStatementQuietly(statement);
                    throw throwable;
                }
                SQLUtils.closeStatementQuietly(statement);
            }
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return this.errors;
    }
}

