/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.upgrade.UpgradeTask;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Category;

public class DailyReportPreferenceUpgradeTask
implements UpgradeTask {
    public static final Category log = Category.getInstance(DailyReportPreferenceUpgradeTask.class);
    private NotificationManager notificationManager;
    private UserAccessor userAccessor;

    public String getBuildNumber() {
        return "204";
    }

    public String getShortDescription() {
        return "Updates the database to store mail";
    }

    public void doUpgrade() throws Exception {
        log.warn((Object)"Updating user preferences to new daily report notification scheme... If you've got a lot of users this may take a while");
        for (User user : this.userAccessor.getUsers()) {
            if (!this.userAccessor.getPropertySet(user).getBoolean("confluence.prefs.email.notify")) continue;
            this.notificationManager.addDailyReportNotfication(user);
        }
        log.info((Object)"Finished updating user preferences");
    }

    public Collection getErrors() {
        return Collections.EMPTY_LIST;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

