/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.core.db.JDBCUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class DropDraftTableUpgradeTask
implements UpgradeTask {
    protected static Log log = LogFactory.getLog(DropDraftTableUpgradeTask.class);
    private SessionFactory sessionFactory;

    public String getBuildNumber() {
        return "513";
    }

    public String getShortDescription() {
        return "Drop the DRAFT table so that it can be recreated with the correct space key length";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Deleting the DRAFT table to fix a database schema issue. This will delete all saved drafts. The table should be recreated by the automated schema update");
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        this.deleteDraftTable(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDraftTable(Session session) throws HibernateException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("drop table DRAFT");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    log.warn((Object)("Unable to drop DRAFTS table. The most likely reason for this is that the table does not exist. If this is the case, you can safely ignore this message. " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(statement);
                    throw throwable;
                }
                JDBCUtils.close((Statement)statement);
            }
        }
        JDBCUtils.close((Statement)statement);
    }

    public Collection getErrors() {
        return null;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

