/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.DefaultBootstrapManager;
import com.atlassian.confluence.util.FontManager;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class FopConfigAndFontMetricsUpgradeTask
implements UpgradeTask {
    FontManager fontManager;

    public String getBuildNumber() {
        return "901";
    }

    public String getShortDescription() {
        return "Regenerates FOP config and font metrics files if a custom font has been installed.";
    }

    public void doUpgrade() {
        File fopXml = new File(this.getFontDir(), "fop.xml");
        if (fopXml.isFile()) {
            try {
                File fontFile = new File(this.getFontDir(), this.getFontFileName(fopXml));
                this.fontManager.installFont(fontFile);
            }
            catch (Throwable e) {
                log.error((Object)"There was an error upgrading the configuration of your custom PDF font. You can resolve this by reinstalling this font from the Admninistration > PDF Language Support page.", e);
            }
        }
    }

    private File getFontDir() {
        return new File(((DefaultBootstrapManager)BootstrapUtils.getBootstrapManager()).getConfluenceHome(), "fonts");
    }

    private String getFontFileName(File fopXml) throws MalformedURLException, DocumentException {
        SAXReader reader = new SAXReader();
        Document fopDoc = reader.read(fopXml);
        Node fontNode = fopDoc.selectSingleNode("//font");
        return fontNode.valueOf("@embed-file");
    }

    public void setFontManager(FontManager fontManager) {
        this.fontManager = fontManager;
    }

    public Collection getErrors() {
        return null;
    }
}

