/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import com.opensymphony.util.TextUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HashTaskListKeysUpgradeTask
implements UpgradeTask {
    private static final Category log = Category.getInstance(HashTaskListKeysUpgradeTask.class);

    public String getBuildNumber() {
        return "217";
    }

    public String getShortDescription() {
        return "Hash all task list titles and the names of their items in the OS_PROPERTYENTRY table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Starting ...");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session hibernateSession = null;
        Statement queryingStatement = null;
        Statement updatingStatement = null;
        Connection connection = null;
        try {
            hibernateSession = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            connection = hibernateSession.connection();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            queryingStatement = connection.createStatement();
            updatingStatement = connection.createStatement();
            ResultSet tasklistResults = queryingStatement.executeQuery("select ENTITY_NAME, ENTITY_ID, ENTITY_KEY from OS_PROPERTYENTRY where ENTITY_KEY like 'tasklist.%'");
            while (tasklistResults.next()) {
                String entityName = tasklistResults.getString(1);
                int entityId = tasklistResults.getInt(2);
                String entityKey = tasklistResults.getString(3);
                StringTokenizer st = new StringTokenizer(entityKey, ".");
                if (st.countTokens() >= 2) {
                    st.nextToken();
                    String taskListName = "";
                    String taskItemName = "";
                    if (st.countTokens() == 2) {
                        taskListName = st.nextToken();
                        taskItemName = st.nextToken();
                    } else {
                        if (st.countTokens() != 1 || !entityKey.startsWith("tasklist..")) continue;
                        taskItemName = st.nextToken();
                    }
                    try {
                        Integer.parseInt(taskListName);
                        Integer.parseInt(taskItemName);
                        log.debug((Object)("Skipping (ENTITY_ID=" + entityId + ", ENTITY_NAME=" + entityName + ", ENTITY_KEY=" + entityKey + ") as it has already been hashed."));
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("Updating (ENTITY_ID=" + entityId + ", ENTITY_NAME=" + entityName + ", ENTITY_KEY=" + entityKey + ")"));
                        int taskListNameHash = TextUtils.noNull((String)taskListName).hashCode();
                        int taskItemNameHash = TextUtils.noNull((String)taskItemName).hashCode();
                        updatingStatement.execute("update OS_PROPERTYENTRY set ENTITY_KEY = 'tasklist." + taskListNameHash + "." + taskItemNameHash + "' where ENTITY_ID = " + entityId + " and ENTITY_NAME = '" + entityName + "' and ENTITY_KEY = '" + entityKey + "'");
                    }
                    continue;
                }
                log.error((Object)("Could not fix/update entry (ENTITY_ID=" + entityId + ", ENTITY_NAME=" + entityName + ", ENTITY_KEY=" + entityKey + ")"));
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            log.info((Object)"Complete. ");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            if (queryingStatement != null) {
                try {
                    queryingStatement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (updatingStatement != null) {
                try {
                    updatingStatement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Collection getErrors() {
        return null;
    }
}

