/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.renderer.ShortcutLinkConfig;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.util.Collection;
import java.util.Map;

public class IntroduceShortcutLinkAliasUpgradeTask
implements DatabaseUpgradeTask {
    private BandanaManager bandanaManager;

    public String getBuildNumber() {
        return "629";
    }

    public String getShortDescription() {
        return "Allows default aliases for Shortcut Links to be stored within bandana.";
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void doUpgrade() throws Exception {
        Map shortcutLinks = (Map)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.shortcut.links");
        if (shortcutLinks == null) {
            return;
        }
        for (Map.Entry entry : shortcutLinks.entrySet()) {
            ShortcutLinkConfig linkConfig = new ShortcutLinkConfig();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            linkConfig.setExpandedValue((String)value);
            entry.setValue(linkConfig);
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.shortcut.links", (Object)shortcutLinks);
    }

    public void doNonDatabaseUpgrade() {
    }

    public Collection getErrors() {
        return null;
    }
}

