/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.upgrade.UpgradeUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.Collection;
import org.apache.log4j.Category;

public class MoveGlobalConfigToBandanaUpgradeTask
implements UpgradeTask {
    public static final Category log = Category.getInstance(MoveGlobalConfigToBandanaUpgradeTask.class);

    public String getBuildNumber() {
        return "603";
    }

    public String getShortDescription() {
        return "Move properties from BootstrapManager into global settings.";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Begin");
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        Settings settings = new Settings(settingsManager.getGlobalSettings());
        settings.setDefaultSpaceHomepageTitle(UpgradeUtils.getExistingStringValue("default.space.homepage.title"));
        settings.setDefaultSpaceHomepageContent(UpgradeUtils.getExistingStringValue("default.space.homepage.content"));
        settings.setBaseUrl(UpgradeUtils.getExistingStringValue("confluence.domain"));
        settings.setAttachmentDataStore(UpgradeUtils.getExistingStringValue("attachment.data.store"));
        settings.setWebdavServerUrl(UpgradeUtils.getExistingStringValue("webdav.server.url"));
        settings.setWebdavUsername(UpgradeUtils.getExistingStringValue("webdav.username"));
        settings.setWebdavPassword(UpgradeUtils.getExistingStringValue("webdav.password"));
        settingsManager.updateGlobalSettings(settings);
        BootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        bootstrapManager.removeProperty("default.space.homepage.title");
        bootstrapManager.removeProperty("default.space.homepage.content");
        bootstrapManager.removeProperty("confluence.domain");
        bootstrapManager.removeProperty("attachment.data.store");
        bootstrapManager.removeProperty("webdav.server.url");
        bootstrapManager.removeProperty("webdav.username");
        bootstrapManager.removeProperty("webdav.password");
        bootstrapManager.save();
        log.info((Object)"Moving settings completed");
    }

    public Collection getErrors() {
        return null;
    }
}

