/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.AttachmentUtils;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.user.persistence.dao.PersonalInformationDao;
import com.atlassian.core.util.FileUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;

public class MoveNonPictureProfileAttachmentsUpgradeTask
implements UpgradeTask {
    public static final Category log = Category.getInstance(MoveNonPictureProfileAttachmentsUpgradeTask.class);
    private PersonalInformationDao personalInformationDao;
    private AttachmentManager attachmentManager;
    private UserAccessor userAccessor;

    public String getBuildNumber() {
        return "503";
    }

    public String getShortDescription() {
        return "Moves profiles attachments that are not profile pictures into <ConfluenceHome>/old/<username>.";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Starting ...");
        if (BootstrapUtils.getBootstrapManager().isWebdavEnabled()) {
            log.info((Object)"Detected WebDAV configuration. Skipping ...");
            return;
        }
        List personalInfos = this.personalInformationDao.findAll();
        for (PersonalInformation personalInformation : personalInfos) {
            List profileAttachments = personalInformation.getAttachments();
            if (!personalInformation.isLatestVersion() || profileAttachments.isEmpty()) continue;
            ProfilePictureInfo profilePicture = this.userAccessor.getUserProfilePicture(personalInformation.getUsername());
            ArrayList<Attachment> attachmentsToRemove = new ArrayList<Attachment>();
            for (Attachment profileAttachment : profileAttachments) {
                if (!profileAttachment.isLatestVersion()) continue;
                try {
                    if (profileAttachment.getFileName().equals(profilePicture.getFileName())) continue;
                    File tempUserDirectory = new File(BootstrapUtils.getBootstrapManager().getConfluenceHome(), "old" + File.separator + personalInformation.getUsername());
                    File niceNameAttachmentDirectory = new File(tempUserDirectory, profileAttachment.getFileName());
                    FileUtils.copyDirectory((File)AttachmentUtils.getContainingFolder(profileAttachment), (File)niceNameAttachmentDirectory);
                    attachmentsToRemove.add(profileAttachment);
                }
                catch (Exception e) {
                    log.error((Object)("Erroring moving attachment: " + profileAttachment), (Throwable)e);
                }
            }
            this.removeMovedAttachments(attachmentsToRemove);
        }
        log.info((Object)"Complete.");
    }

    private void removeMovedAttachments(List attachmentsToRemove) {
        try {
            for (Attachment attachment : attachmentsToRemove) {
                this.attachmentManager.removeAttachmentFromServer(attachment);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error removing moved attachments", (Throwable)e);
        }
    }

    public Collection getErrors() {
        return null;
    }

    public void setPersonalInformationDao(PersonalInformationDao personalInformationDao) {
        this.personalInformationDao = personalInformationDao;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

