/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.plugin.persistence.PluginData;
import com.atlassian.confluence.plugin.persistence.PluginDataDao;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.FilePluginJar;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.log4j.Category;

public class MovePluginsToDatabaseUpgradeTask
implements DatabaseUpgradeTask {
    private static final Category log = Category.getInstance(MovePluginsToDatabaseUpgradeTask.class);
    private BootstrapManager bootstrapManager;
    private PluginDataDao pluginDataDao;
    private DescriptorParserFactory descriptorParserFactory;

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setPluginDataDao(PluginDataDao pluginDataDao) {
        this.pluginDataDao = pluginDataDao;
    }

    public void setDescriptorParserFactory(DescriptorParserFactory descriptorParserFactory) {
        this.descriptorParserFactory = descriptorParserFactory;
    }

    public String getBuildNumber() {
        return "630";
    }

    public String getShortDescription() {
        return "Move uploaded plugins to the database";
    }

    public void doUpgrade() throws Exception {
        File pluginDir = ConfluencePluginUtils.getPluginDirectory(this.bootstrapManager);
        File[] files = pluginDir.listFiles();
        for (int fileIdx = 0; fileIdx < files.length; ++fileIdx) {
            File pluginFile = files[fileIdx];
            try {
                this.movePluginToDatabase(pluginFile);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Could not move plugin file '" + pluginFile.getName() + "' to database. Try re-installing this plugin."), (Throwable)e);
            }
        }
        this.doNonDatabaseUpgrade();
    }

    public void doNonDatabaseUpgrade() {
        File pluginDir = ConfluencePluginUtils.getPluginDirectory(this.bootstrapManager);
        File[] files = pluginDir.listFiles();
        for (int fileIdx = 0; fileIdx < files.length; ++fileIdx) {
            File pluginFile = files[fileIdx];
            if (pluginFile.delete()) continue;
            log.error((Object)("Error removing plugin: " + pluginFile.getPath()));
        }
        if (!pluginDir.delete()) {
            log.info((Object)"Could not delete old plugins directory because there are still files in it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePluginToDatabase(File pluginFile) throws PluginParseException {
        InputStream pluginJarInputStream = null;
        InputStream pluginDescriptorStream = null;
        try {
            FilePluginJar pluginJar = new FilePluginJar(pluginFile);
            pluginDescriptorStream = pluginJar.getFile("atlassian-plugin.xml");
            pluginJarInputStream = pluginJar.getInputStream();
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptorStream);
            PluginData pluginData = new PluginData();
            pluginData.setKey(parser.getKey());
            pluginData.setFileName(pluginJar.getFileName());
            pluginData.setData(pluginJarInputStream);
            this.pluginDataDao.saveOrUpdate(pluginData);
        }
        finally {
            try {
                if (pluginJarInputStream != null) {
                    pluginJarInputStream.close();
                }
                if (pluginDescriptorStream != null) {
                    pluginDescriptorStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error closing jar input stream.", (Throwable)e);
            }
        }
    }

    public Collection getErrors() {
        return null;
    }
}

