/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.renderer.UserMacroConfig;
import com.atlassian.confluence.renderer.UserMacroLibrary;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.Collection;
import java.util.Map;

public class MoveUserMacrosToBandanaUpgradeTask
implements UpgradeTask {
    private static final String PREFIX = "confluence.macro.user.";

    public String getBuildNumber() {
        return "113";
    }

    public String getShortDescription() {
        return "Copies user macros from confluence.cfg.xml over to new bandana configuration.";
    }

    public void doUpgrade() throws Exception {
        BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
        UserMacroLibrary userMacroLibrary = (UserMacroLibrary)ContainerManager.getComponent((String)"userMacroLibrary");
        Map userMacroTemplates = bootstrapManager.getPropertiesWithPrefix(PREFIX);
        if (userMacroTemplates != null && userMacroTemplates.size() > 0) {
            for (Map.Entry entry : userMacroTemplates.entrySet()) {
                String macroKey = (String)entry.getKey();
                String macroTemplate = (String)entry.getValue();
                if (macroKey.length() <= PREFIX.length()) continue;
                UserMacroConfig config = new UserMacroConfig();
                config.setName(this.extractMacroNameFromKey(macroKey));
                config.setTemplate(macroTemplate);
                userMacroLibrary.addUpdateMacro(config);
                bootstrapManager.removeProperty(macroKey);
            }
        }
        bootstrapManager.save();
    }

    private String extractMacroNameFromKey(String macroKey) {
        return macroKey.substring(PREFIX.length());
    }

    public Collection getErrors() {
        return null;
    }
}

