/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.upgrade.UpgradeUtils;
import com.atlassian.core.util.FileUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class NewConfigUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(NewConfigUpgradeTask.class);

    public String getBuildNumber() {
        return "106";
    }

    public String getShortDescription() {
        return "Retrieves existing Confluence setup settings and sets them onto new Configuration Beans";
    }

    public void doUpgrade() throws Exception {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        Settings settings = new Settings(settingsManager.getGlobalSettings());
        settings.setAllowCamelCase(UpgradeUtils.getExistingBooleanValue("property.render.allowcamelcase"));
        settings.setAllowThreadedComments(UpgradeUtils.getExistingBooleanValue("property.comments.thread"));
        settings.setAllowTrackbacks(UpgradeUtils.getExistingBooleanValue("property.trackbacks"));
        settings.setDenyPublicSignup(UpgradeUtils.getExistingBooleanValue("property.deny.signup"));
        settings.setExternalUserManagement(UpgradeUtils.getExistingBooleanValue("property.user.externalmanagement"));
        settings.setViewSpaceGoesToSpaceSummary(UpgradeUtils.getExistingBooleanValue("property.viewspacegoestospacesummary"));
        settings.getReferrerSettings().setHideExternalReferrers(UpgradeUtils.getExistingBooleanValue("property.hide.external.referrers"));
        settings.getReferrerSettings().setExcludedReferrers(this.getExcludedReferrers());
        String multipartMaxSize = UpgradeUtils.getExistingStringValue("webwork.multipart.maxSize");
        try {
            settings.setAttachmentMaxSize(Long.parseLong(multipartMaxSize));
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error parsing maximum attachment size: " + multipartMaxSize));
        }
        settings.setEmailAddressVisibility(UpgradeUtils.getExistingStringValue("property.email.address.visibility"));
        settings.setSiteHomePage(UpgradeUtils.getExistingStringValue("property.sitehomepagespacekey"));
        settings.setSiteWelcomeMessage(UpgradeUtils.getExistingStringValue("property.sitewelcomemessage"));
        settings.setDefaultEncoding(UpgradeUtils.getExistingStringValue("webwork.i18n.encoding"));
        if (UpgradeUtils.getExistingIntegerValue("property.max.thumbnail.height") > 0) {
            settings.setMaxThumbHeight(UpgradeUtils.getExistingIntegerValue("property.max.thumbnail.height"));
        }
        if (UpgradeUtils.getExistingIntegerValue("property.max.thumbnail.width") > 0) {
            settings.setMaxThumbWidth(UpgradeUtils.getExistingIntegerValue("property.max.thumbnail.width"));
        }
        settingsManager.updateGlobalSettings(settings);
        BootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        bootstrapManager.removeProperty("property.render.allowcamelcase");
        bootstrapManager.removeProperty("property.comments.thread");
        bootstrapManager.removeProperty("property.trackbacks");
        bootstrapManager.removeProperty("property.deny.signup");
        bootstrapManager.removeProperty("property.user.externalmanagement");
        bootstrapManager.removeProperty("property.viewspacegoestospacesummary");
        bootstrapManager.removeProperty("property.hide.external.referrers");
        bootstrapManager.removeProperty("webwork.multipart.maxSize");
        bootstrapManager.removeProperty("property.email.address.visibility");
        bootstrapManager.removeProperty("property.sitehomepagespacekey");
        bootstrapManager.removeProperty("property.sitewelcomemessage");
        bootstrapManager.removeProperty("property.excludedfromexternalreferrers");
        bootstrapManager.save();
        String CONFLUENCE_MAIL_CFG = "confluence-mail.cfg.xml";
        File mailConfigFile = new File(bootstrapManager.getConfluenceHome() + File.separator + "confluence-mail.cfg.xml");
        if (mailConfigFile.exists()) {
            File newConfigFile = new File(bootstrapManager.getConfluenceHome() + File.separator + "config" + File.separator + "confluence-mail.cfg.xml");
            FileUtils.copyFile((File)mailConfigFile, (File)newConfigFile, (boolean)false);
            if (newConfigFile.exists()) {
                mailConfigFile.delete();
            }
        }
    }

    public Collection getErrors() {
        return null;
    }

    public List getExcludedReferrers() {
        String prop = BootstrapUtils.getBootstrapManager().getString("property.excludedfromexternalreferrers");
        prop = prop != null ? prop : "";
        StringTokenizer st = new StringTokenizer(prop, " \t\n\r\f;,");
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String excludedReferrer = st.nextToken().trim();
            result.add(excludedReferrer);
        }
        return result;
    }
}

