/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.persistence.dao.SpacePermissionDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.upgrade.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;

public class NewSpacePermissionsUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(UpgradeTask.class);
    private List errors = new ArrayList();
    private SpacePermissionManager permissionManager;
    private SpacePermissionDao permissionDao;

    public void setSpacePermissionManager(SpacePermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setSpacePermissionDao(SpacePermissionDao permissionDao) {
        this.permissionDao = permissionDao;
    }

    public String getBuildNumber() {
        return "103";
    }

    public String getShortDescription() {
        return "Add new space-level permissions";
    }

    public void doUpgrade() throws Exception {
        try {
            log.info((Object)"Starting to upgrade permissions from 1.2 -> 1.3");
            List permissions = this.permissionDao.findAll();
            for (SpacePermission permission : permissions) {
                this.fix(permission);
            }
            log.info((Object)"Finished upgrading permissions");
        }
        catch (Exception e) {
            log.error((Object)"Upgrade task could not fix permissions: permissions may need manual checking", (Throwable)e);
            this.errors.add("Upgrade task could not fix permissions: permissions may need manual checking: " + e.getMessage());
        }
    }

    private void fix(SpacePermission permission) {
        Space space = permission.getSpace();
        if (space != null) {
            if ("VIEWSPACE".equals(permission.getType())) {
                this.addViewPermissions(permission);
            } else if ("EDITSPACE".equals(permission.getType())) {
                this.addEditPermissions(permission);
            }
        }
    }

    private void addEditPermissions(SpacePermission permission) {
        this.addCopiedPermission(permission, "REMOVEPAGE");
        this.addCopiedPermission(permission, "EDITBLOG");
        this.addCopiedPermission(permission, "REMOVEBLOG");
        this.addCopiedPermission(permission, "REMOVECOMMENT");
        this.addCopiedPermission(permission, "CREATEATTACHMENT");
        this.addCopiedPermission(permission, "REMOVEATTACHMENT");
    }

    private void addViewPermissions(SpacePermission permission) {
        this.addCopiedPermission(permission, "EXPORTPAGE");
        this.addCopiedPermission(permission, "EXPORTSPACE");
    }

    private void addCopiedPermission(SpacePermission permission, String newPermissionType) {
        SpacePermission newPermission = this.clonePermission(permission, newPermissionType);
        permission.getSpace().addPermission(newPermission);
        this.permissionManager.savePermission(newPermission);
    }

    private SpacePermission clonePermission(SpacePermission permission, String type) {
        return new SpacePermission(type, permission.getSpace(), permission.getGroup(), permission.getUserName());
    }

    public Collection getErrors() {
        return this.errors;
    }
}

