/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class PagePropertiesUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(PagePropertiesUpgradeTask.class);

    public String getBuildNumber() {
        return "206";
    }

    public String getShortDescription() {
        return "Creates a new TEXT_VAL column to store properties longer than 255 char.";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Starting upgrade task. Create TEXT_VAL column");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        if (((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("PostgreSQLDialect")) {
            this.updateSchema(session);
        }
        log.info((Object)"TEXT_VAL column created, upgrade task complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("alter table OS_PROPERTYENTRY add column TEXT_VAL TEXT NULL");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Unable to add TEXT_VAL column to OS_PROPERTYENTRY table: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(statement);
                    throw throwable;
                }
                JDBCUtils.close((Statement)statement);
            }
        }
        JDBCUtils.close((Statement)statement);
    }

    public Collection getErrors() {
        return null;
    }
}

