/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class PersonalInformationRepairTask
implements Runnable {
    private static Logger log = Logger.getLogger(PersonalInformationRepairTask.class);
    private UserAccessor userAccessor;
    private PersonalInformationManager personalInformationManager;
    private SessionFactory sessionFactory;

    public PersonalInformationRepairTask(PersonalInformationManager personalInformationManager, SessionFactory sessionFactory, UserAccessor userAccessor) {
        this.personalInformationManager = personalInformationManager;
        this.sessionFactory = sessionFactory;
        this.userAccessor = userAccessor;
    }

    public void run() {
        log.info((Object)"Beginning PersonalInformation repair.");
        try {
            log.debug((Object)"Retrieving from database the usernames from content which have no matching Personal Information.");
            JdbcTemplate template = new JdbcTemplate(this.getDataSource());
            HashSet missingUserNames = new HashSet();
            UsernameCallbackHandler usernameCallbackHandler = new UsernameCallbackHandler(missingUserNames);
            template.query("select distinct(c.CREATOR) from CONTENT c LEFT OUTER JOIN CONTENT pi on c.CREATOR = pi.USERNAME where pi.USERNAME IS NULL AND c.CREATOR IS NOT NULL", new Object[0], (RowCallbackHandler)usernameCallbackHandler);
            template.query("select distinct(c.LASTMODIFIER) from CONTENT c LEFT OUTER JOIN CONTENT pi on c.LASTMODIFIER = pi.USERNAME where pi.USERNAME IS NULL AND c.LASTMODIFIER IS NOT NULL", new Object[0], (RowCallbackHandler)usernameCallbackHandler);
            log.info((Object)("Found " + missingUserNames.size() + " usernames that need to be retrieved."));
            int i = 0;
            for (String username : missingUserNames) {
                User user = this.userAccessor.getUser(username);
                if (user == null) {
                    log.debug((Object)("No full name found for the username " + username));
                    user = new DefaultUser(username);
                }
                this.personalInformationManager.createPersonalInformation(user);
                if (++i % 10 != 0) continue;
                log.debug((Object)("Created " + i + " from " + missingUserNames.size() + " missing Personal Information objects."));
            }
        }
        catch (RuntimeException ex) {
            log.warn((Object)"Unable to complete Personal Information repair. The documentation at http://confluence.atlassian.com/display/DEV/Enabling+Contributor+Filtering+for+Search#manualfix will provide information on running the task again manually.", (Throwable)ex);
            throw ex;
        }
        log.info((Object)"Finished Personal Information repair.");
    }

    private DataSource getDataSource() {
        Connection conn;
        Session hibernateSession = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        try {
            conn = hibernateSession.connection();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        return new SingleConnectionDataSource(conn, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UsernameCallbackHandler
    implements RowCallbackHandler {
        private final Set<String> missingUserNames;

        private UsernameCallbackHandler(Set<String> missingUserNames) {
            this.missingUserNames = missingUserNames;
        }

        public void processRow(ResultSet resultset) throws SQLException {
            this.missingUserNames.add(resultset.getString(1));
        }
    }
}

