/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.AttachmentUtils;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.core.util.FileUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Category;

public class PurgeThumbnailsUpgradeTask
implements UpgradeTask {
    protected Category log = Category.getInstance(this.getClass());
    private AttachmentManager attachmentManager;

    public String getBuildNumber() {
        return "59";
    }

    public String getShortDescription() {
        return "Removes all thumbnails that were created in 1.2 with the old thumbnail generating algorithm. This will allow more high quality thumbnails to be generated the next time these thumbnails are loaded.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        Object session = null;
        try {
            AttachmentDao attachmentDao = this.attachmentManager.getAttachmentDao();
            if (BootstrapUtils.getBootstrapManager().isWebdavEnabled()) {
                File thumbnailDirectory = new File(BootstrapUtils.getBootstrapManager() + ThumbnailManager.THUMBNAIL_PATH_SUFFIX);
                if (!FileUtils.deleteDir((File)thumbnailDirectory)) {
                    this.log.error((Object)("Error removing thumbnails directory [" + thumbnailDirectory + "] from confluence home"));
                }
            } else {
                Iterator iterator = attachmentDao.findLatestVersionsIterator();
                while (iterator.hasNext()) {
                    File thumbnailFile;
                    Attachment attachment = (Attachment)iterator.next();
                    if (!attachment.isLatestVersion() || !(thumbnailFile = new File(AttachmentUtils.getOldContainingFolder(attachment), "thumb_" + attachment.getFileName())).exists() || thumbnailFile.delete()) continue;
                    this.log.error((Object)("Error removing thumbnail with path " + thumbnailFile.getAbsolutePath()));
                }
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Error occurred in performing the purge thumbnails upgrade task", e);
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public Collection getErrors() {
        return new ArrayList();
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

