/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.util.AncestorTableBuilder;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.util.Collection;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;

public class RebuildAncestorsUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger log = Logger.getLogger(RebuildAncestorsUpgradeTask.class);
    private final AncestorTableBuilder builder = new AncestorTableBuilder();
    private final SessionFactory sessionFactory;

    public RebuildAncestorsUpgradeTask(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getBuildNumber() {
        return "1419";
    }

    public String getShortDescription() {
        return "Rebuilds the ancestor table";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Starting rebuild ancestors upgrade task.");
        this.builder.build(this.sessionFactory);
        if (this.builder.getErrors().isEmpty()) {
            log.info((Object)"Rebuilding ancestors sucessfully complete.");
        }
    }

    public Collection getErrors() {
        return this.builder.getErrors();
    }

    public void doNonDatabaseUpgrade() {
    }
}

