/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.upgrade.UpgradeUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.util.Collection;
import net.sf.hibernate.Session;
import org.apache.log4j.Category;

public class ReduceIndexNameLengthUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(ReduceIndexNameLengthUpgradeTask.class);

    public String getBuildNumber() {
        return "409";
    }

    public String getShortDescription() {
        return "Recreate indexes whose names are too long for DB2";
    }

    public void doUpgrade() throws Exception {
        Session session = UpgradeUtils.getSession();
        UpgradeUtils.dropIndex(session, "sp_permusername_idx", "SPACEPERMISSIONS", log);
        UpgradeUtils.dropIndex(session, "sp_permgroupname_idx", "SPACEPERMISSIONS", log);
        UpgradeUtils.createIndex(session, "sp_puname_idx", "SPACEPERMISSIONS", "PERMUSERNAME", log);
        UpgradeUtils.createIndex(session, "sp_pgname_idx", "SPACEPERMISSIONS", "PERMGROUPNAME", log);
    }

    public Collection getErrors() {
        return null;
    }
}

