/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class RemoveDuplicateTaskListKeysUpgradeTask
implements UpgradeTask {
    private static final Category log = Category.getInstance(RemoveDuplicateTaskListKeysUpgradeTask.class);

    public String getBuildNumber() {
        return "216";
    }

    public String getShortDescription() {
        return "Removes task list items from OS_PROPERTYENTRY table which differ only by trailing spaces.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Starting ...");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session hibernateSession = null;
        Statement queryingStatement = null;
        Statement updatingStatement = null;
        Statement removingStatement = null;
        Connection connection = null;
        try {
            hibernateSession = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            connection = hibernateSession.connection();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            queryingStatement = connection.createStatement();
            updatingStatement = connection.createStatement();
            removingStatement = connection.createStatement();
            ResultSet tasklistResults = queryingStatement.executeQuery("select ENTITY_NAME, ENTITY_ID, ENTITY_KEY from OS_PROPERTYENTRY where ENTITY_KEY like 'tasklist.%'");
            ArrayList<String> osPropertyEntryKeys = new ArrayList<String>();
            while (tasklistResults.next()) {
                String entityName = tasklistResults.getString(1);
                int entityId = tasklistResults.getInt(2);
                String entityKey = tasklistResults.getString(3);
                String taskListName = "";
                String taskItemName = "";
                StringTokenizer st = new StringTokenizer(entityKey, ".");
                if (st.countTokens() >= 2) {
                    st.nextToken();
                    if (st.countTokens() == 2) {
                        taskListName = st.nextToken();
                        taskItemName = st.nextToken();
                    } else {
                        if (st.countTokens() != 1 || !entityKey.startsWith("tasklist..")) continue;
                        taskItemName = st.nextToken();
                    }
                    log.debug((Object)("Updating (ENTITY_ID=" + entityId + ", ENTITY_NAME=" + entityName + ", ENTITY_KEY=" + entityKey + ")"));
                    String compositeKey = entityName + entityId + taskListName.trim() + taskItemName.trim();
                    if (osPropertyEntryKeys.contains(compositeKey)) {
                        log.debug((Object)"Removing this entry because it has been identified as a duplicate (once trailing spaces has been removed).");
                        removingStatement.execute("delete from OS_PROPERTYENTRY where ENTITY_ID=" + entityId + " and ENTITY_NAME='" + entityName + "' and ENTITY_KEY='" + entityKey + "'");
                    }
                    osPropertyEntryKeys.add(compositeKey);
                    continue;
                }
                log.error((Object)("Could not fix/update entry (ENTITY_ID=" + entityId + ", ENTITY_NAME=" + entityName + ", ENTITY_KEY=" + entityKey + ")"));
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            log.info((Object)"Complete. ");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            if (queryingStatement != null) {
                try {
                    queryingStatement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (updatingStatement != null) {
                try {
                    updatingStatement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (removingStatement != null) {
                try {
                    removingStatement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Collection getErrors() {
        return null;
    }
}

