/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class RemoveEmailTemplatesTableUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(RemoveEmailTemplatesTableUpgradeTask.class);

    public String getBuildNumber() {
        return "306";
    }

    public String getShortDescription() {
        return "Remove the emailtemplates table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning database update: emailtemplates");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = null;
        try {
            session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            this.updateSchema(session);
        }
        finally {
            log.info((Object)"Completed database update: emailtemplates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            this.doDDLOperationIgnoringErrors(statement, "alter table EMAILTEMPLATES drop constraint FKA986AB1DB2DC6081");
            this.doDDLOperationIgnoringErrors(statement, "alter table EMAILTEMPLATES drop constraint FKA986AB1D17D4A070");
            this.doDDLOperationIgnoringErrors(statement, "drop table EMAILTEMPLATES");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(statement);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    private void doDDLOperationIgnoringErrors(Statement statement, String operation) {
        try {
            statement.execute(operation);
        }
        catch (Exception e) {
            log.debug((Object)("Unimportant error on operation " + operation + "(THIS DOES NOT AFFECT THE SUCCESS OF THE UPGRADE)"), (Throwable)e);
        }
    }

    public Collection getErrors() {
        return null;
    }
}

