/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;

public class RemoveGlobalAnonymousPermissionsUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(UpgradeTask.class);
    private List errors = new ArrayList();

    public String getBuildNumber() {
        return "314";
    }

    public String getShortDescription() {
        return "Remove the CREATESPACE and ADMINISTRATECONFLUENCE global permissions for the anonymous user.";
    }

    public void doUpgrade() throws Exception {
        try {
            int i;
            log.info((Object)"Starting to remove obsolete global anonymous permissions");
            SpacePermissionManager permissionManager = (SpacePermissionManager)ContainerManager.getComponent((String)"spacePermissionManager");
            List globalPermissions = permissionManager.getGlobalPermissions();
            ArrayList<SpacePermission> permissionsToRemove = new ArrayList<SpacePermission>();
            for (i = 0; i < globalPermissions.size(); ++i) {
                Object o = globalPermissions.get(i);
                if (!(o instanceof SpacePermission)) {
                    throw new Exception("Expected object to be a SpacePermission, but was " + o.getClass());
                }
                SpacePermission permission = (SpacePermission)o;
                if (!permission.isInvalidAnonymousPermission()) continue;
                permissionsToRemove.add(permission);
            }
            for (i = 0; i < permissionsToRemove.size(); ++i) {
                SpacePermission spacePermission = (SpacePermission)permissionsToRemove.get(i);
                permissionManager.removePermission(spacePermission);
            }
            permissionManager.flushCaches();
            log.info((Object)"Finished removing obsolete global anonymous permissions");
        }
        catch (Exception e) {
            log.error((Object)"Upgrade task could not remove permissions: permissions may need manual checking", (Throwable)e);
            this.errors.add("Upgrade task could not remove permissions: permissions may need manual checking: " + e.getMessage());
        }
    }

    public Collection getErrors() {
        return this.errors;
    }
}

