/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class RemoveOldCommentVersionFromParentComment
implements UpgradeTask {
    private static Category log = Category.getInstance(RemoveOldCommentVersionFromParentComment.class);
    private SessionFactory sessionFactory;
    private Collection errors = new ArrayList();

    public String getBuildNumber() {
        return "210";
    }

    public String getShortDescription() {
        return "Remove previous versions of modified comments from the parent comments list of children. See CONF-2941.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        Statement s = null;
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            Connection c = session.connection();
            s = c.createStatement();
            s.execute("update CONTENT set PARENTCOMMENTID = null where CONTENTTYPE = 'COMMENT' and PAGEID is null and PARENTCOMMENTID is not null");
            c.commit();
        }
        catch (Exception e) {
            log.error((Object)("Upgrade failed:" + e.getMessage()), (Throwable)e);
            this.errors.add("Error performing upgrade " + e.toString());
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

