/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class SeparateContentBodyTableUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(SeparateContentBodyTableUpgradeTask.class);

    public String getBuildNumber() {
        return "316";
    }

    public String getShortDescription() {
        return "Move content bodies to a separate table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning database update: SeparateContentBodyTableUpgradeTask");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            this.updateDatabase(session);
        }
        finally {
            log.info((Object)"Completed database update: SeparateContentBodyTableUpgradeTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabase(Session session) throws HibernateException, SQLException {
        Statement insert = null;
        try {
            Connection conn = session.connection();
            insert = conn.createStatement();
            insert.execute("insert into BODYCONTENT (BODYCONTENTID, CONTENTID, BODY) select CONTENTID, CONTENTID, BODY from CONTENT");
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(insert);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(insert);
    }

    public Collection getErrors() {
        return null;
    }
}

