/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class UpgradeUtils {
    private static Category log = Category.getInstance(UpgradeUtils.class);

    public static void createIndex(Session session, String indexName, String tableName, String columns, Category log) throws HibernateException, SQLException {
        if (indexName.length() > 18) {
            throw new RuntimeException("Index name is too long for DB2");
        }
        String createIndexStatement = "create index " + indexName + " on " + tableName + " (" + columns + ")";
        UpgradeUtils.executeDdl(session, createIndexStatement, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdl(Session session, String sql, Category log) throws HibernateException {
        Statement statement = null;
        Connection connection = null;
        try {
            log.info((Object)("Running ddl:" + sql));
            connection = session.connection();
            if (connection.isClosed()) {
                if (session.isConnected()) {
                    session.disconnect();
                }
                session.reconnect();
                connection = session.connection();
            }
            statement = connection.createStatement();
            statement.execute(sql);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            log.info((Object)"DDL executed.");
            SQLUtils.closeStatementQuietly(statement);
        }
        catch (Exception e) {
            log.error((Object)("Error running ddl:" + sql), (Throwable)e);
        }
        finally {
            SQLUtils.closeStatementQuietly(statement);
        }
    }

    public static Session getSession() {
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        return session;
    }

    public static void dropIndex(Session session, String indexName, String tableName, Category log) throws HibernateException {
        String sql = "drop index " + indexName;
        if (UpgradeUtils.isMySQL()) {
            sql = sql + " on " + tableName;
        } else if (UpgradeUtils.isMSSQL() || UpgradeUtils.isSybase()) {
            sql = "drop index " + tableName + "." + indexName;
        }
        UpgradeUtils.executeDdl(session, sql, log);
    }

    public static boolean isMySQL() {
        return ((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("MySQLDialect");
    }

    public static boolean isMSSQL() {
        return ((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("SQLServerDialect");
    }

    public static boolean isSybase() {
        return ((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).indexOf("Sybase") != -1;
    }

    public static String getExistingStringValue(String key) {
        return BootstrapUtils.getBootstrapManager().getString(key);
    }

    public static boolean getExistingBooleanValue(String key) {
        return BootstrapUtils.getBootstrapManager().isPropertyTrue(key);
    }

    public static int getExistingIntegerValue(String key) {
        String result = BootstrapUtils.getBootstrapManager().getString(key);
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error parsing integer value associated with key: " + key));
            return -1;
        }
    }
}

