/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class VersionedAttachmentDatabaseUpgradeTask
implements UpgradeTask {
    public String getBuildNumber() {
        return "52";
    }

    public String getShortDescription() {
        return "Updates the database to cater for versioned attachments";
    }

    public void doUpgrade() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        if (((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("PostgreSQLDialect")) {
            this.updateSchema(session);
        }
        this.updateAttachmentsTable(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttachmentsTable(Session session) throws HibernateException, SQLException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("update ATTACHMENTS set VERSION = 1");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                block5: {
                    try {
                        SQLUtils.closeStatementQuietly(statement);
                        Connection connection = session.connection();
                        statement = connection.createStatement();
                        statement.execute("update ATTACHMENTS set ATTVERSION = 1");
                        if (connection.getAutoCommit()) break block5;
                        connection.commit();
                    }
                    catch (Throwable throwable) {
                        SQLUtils.closeStatementQuietly(statement);
                        throw throwable;
                    }
                }
                SQLUtils.closeStatementQuietly(statement);
            }
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute("alter table ATTACHMENTS add column ATTACHMENT_COMMENT VARCHAR(255)");
            statement.execute("alter table ATTACHMENTS add column VERSION int");
            statement.execute("alter table ATTACHMENTS add column PREVVER bigint");
            statement.execute("alter table ATTACHMENTS add constraint fk54475f9017d4a070 foreign key (ATTACHMENTID) references ATTACHMENTS");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(statement);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return null;
    }
}

