/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.impl;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.core.persistence.VersionHistoryDao;
import com.atlassian.confluence.event.events.admin.ConfluenceReadyEvent;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicenseUtils;
import com.atlassian.upgrade.AbstractUpgradeManager;
import com.atlassian.upgrade.UpgradeException;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefaultUpgradeManager
extends AbstractUpgradeManager {
    public static final Logger log = Logger.getLogger(DefaultUpgradeManager.class);
    private CacheManager cacheManager;
    private EventManager eventManager;
    private VersionHistoryDao versionHistoryDao;
    private ClusterManager clusterManager;
    private Boolean permitDatabaseUpgrades;
    public static final String CLUSTER_UPGRADE_LOCK = "cluster.upgrade.lock";

    protected String getRealBuildNumber() {
        return GeneralUtil.getBuildNumber();
    }

    protected String getDatabaseBuildNumber() {
        int databaseBuildNumber = this.versionHistoryDao.getLatestBuildNumber();
        return databaseBuildNumber == 0 ? this.getConfiguredBuildNumber() : Integer.toString(databaseBuildNumber);
    }

    public boolean isUpgradeAllowed() {
        boolean isValidPartnerLicense;
        License license = LicenseManager.getInstance().getLicense("CONF");
        Date buildDate = GeneralUtil.getBuildDate();
        Date supportExpiryDate = new Date(LicenseUtils.getSupportPeriodEnd((License)license));
        boolean stillSupported = buildDate.before(supportExpiryDate);
        boolean bl = isValidPartnerLicense = GeneralUtil.checkPartnerDetails(license, GeneralUtil.getBuildPartner()) == null;
        if (log.isEnabledFor((Priority)Level.WARN)) {
            String youNeedTo = "You need to renew the license before you can upgrade to this version of Confluence.";
            if (!stillSupported) {
                log.warn((Object)("Your license is now outside of it's support period. " + youNeedTo));
            }
            if (!isValidPartnerLicense) {
                log.warn((Object)("Your license is not from a valid Atlassian partner. " + youNeedTo));
            }
        }
        return stillSupported && isValidPartnerLicense;
    }

    public void upgrade(JohnsonEventContainer johnson) throws UpgradeException {
        super.upgrade(johnson);
        if (!johnson.hasEvents()) {
            this.eventManager.publishEvent((Event)new ConfluenceReadyEvent((Object)this));
        }
    }

    protected void setDatabaseBuildNumber(String databaseBuildNumber) throws Exception {
        try {
            int currentBuildNumber = Integer.parseInt(databaseBuildNumber);
            int previousBuildNumber = this.versionHistoryDao.getLatestBuildNumber();
            if (previousBuildNumber < currentBuildNumber && this.permitDatabaseUpgrades()) {
                this.versionHistoryDao.addBuildToHistory(currentBuildNumber);
            } else {
                log.info((Object)"Not setting database version on subsequent nodes of cluster. Database upgrades have already been run.");
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Unable to write build number to database - build number could not be parsed: " + databaseBuildNumber));
        }
    }

    protected void postUpgrade() {
        this.cacheManager.flushCaches();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean permitDatabaseUpgrades() throws UpgradeException {
        if (this.permitDatabaseUpgrades != null) return this.permitDatabaseUpgrades;
        if (this.clusterManager.isClustered()) {
            Lock upgradeLock = this.clusterManager.getLock(CLUSTER_UPGRADE_LOCK);
            if (upgradeLock.tryLock()) {
                log.debug((Object)"Cluster upgrade lock acquired.");
                boolean tagSuccessful = this.versionHistoryDao.tagBuild(Integer.parseInt(this.getConfiguredBuildNumber()), "pre_upgrade_version");
                if (!tagSuccessful) throw new UpgradeException("Cannot proceed with upgrade. Cluster upgrade lock acquired but could not successfully tag build number in the CONFVERSION table. This may because you are trying to rerun an upgrade that has failed or there are communication problems between one or more nodes in your cluster. Please zip up your logs and attach onto a support ticket at http://support.atlassian.com.");
                this.permitDatabaseUpgrades = Boolean.TRUE;
                upgradeLock.unlock();
                return this.permitDatabaseUpgrades;
            } else {
                log.debug((Object)"Cluster upgrade lock could not be acquired. Disallowing database upgrades on this node.");
                this.permitDatabaseUpgrades = Boolean.FALSE;
            }
            return this.permitDatabaseUpgrades;
        } else {
            this.permitDatabaseUpgrades = Boolean.TRUE;
        }
        return this.permitDatabaseUpgrades;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setVersionHistoryDao(VersionHistoryDao versionHistoryDao) {
        this.versionHistoryDao = versionHistoryDao;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }
}

