/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.security;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.persistence.dao.PageDao;
import com.atlassian.confluence.upgrade.security.LegacyContentPermission;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class LegacyContentPermissionUpgrader {
    public static final Category log = Category.getInstance(LegacyContentPermissionUpgrader.class);
    SessionFactory sessionFactory;
    PageDao pageDao;
    ContentPermissionManager contentPermissionManager;

    public void run() throws HibernateException {
        List legacyPermissions = this.getSession().find("from LegacyContentPermission");
        for (LegacyContentPermission legacyContentPermission : legacyPermissions) {
            if (legacyContentPermission.isValid()) {
                ContentEntityObject content = legacyContentPermission.getContent();
                this.contentPermissionManager.addContentPermission(legacyContentPermission.toContentPermission(), content);
            } else {
                log.error((Object)("Corrupt Content Permission found.  It will be removed: " + legacyContentPermission));
            }
            legacyContentPermission.setContent(null);
            this.getSession().delete((Object)legacyContentPermission);
        }
        this.getSession().flush();
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    private Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public PageDao getPageDao() {
        return this.pageDao;
    }

    public void setPageDao(PageDao pageDao) {
        this.pageDao = pageDao;
    }
}

