/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;

public class ConfluenceGroupJoiningAuthenticator
extends ConfluenceAuthenticator {
    private static Category log = Category.getInstance(ConfluenceGroupJoiningAuthenticator.class);
    private GroupManager groupManager;

    public boolean login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, final String username, String password, boolean b) throws AuthenticatorException {
        boolean success = super.login(httpServletRequest, httpServletResponse, username, password, b);
        if (success) {
            HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory(), true);
            hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    try {
                        Transaction transaction = session.beginTransaction();
                        User user = ConfluenceGroupJoiningAuthenticator.this.getUserAccessor().getUser(username);
                        Group confluenceUsers = ConfluenceGroupJoiningAuthenticator.this.getGroupManager().getGroup("confluence-users");
                        if (!ConfluenceGroupJoiningAuthenticator.this.getGroupManager().hasMembership(confluenceUsers, user)) {
                            ConfluenceGroupJoiningAuthenticator.this.getGroupManager().addMembership(confluenceUsers, user);
                        }
                        transaction.commit();
                    }
                    catch (EntityException e) {
                        log.error((Object)("Failed to add " + username + " to confluence-users: " + e.getMessage()), (Throwable)e);
                    }
                    return null;
                }
            });
        }
        return success;
    }

    private SessionFactory getSessionFactory() {
        return (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    protected GroupManager getGroupManager() {
        if (this.groupManager == null) {
            this.groupManager = (GroupManager)ContainerManager.getComponent((String)"groupManager");
        }
        return this.groupManager;
    }
}

