/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultContentEntityManager;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.event.events.content.user.PersonalInformationCreateEvent;
import com.atlassian.confluence.event.events.content.user.PersonalInformationRemoveEvent;
import com.atlassian.confluence.event.events.content.user.PersonalInformationUpdateEvent;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.persistence.dao.PersonalInformationDao;
import com.atlassian.event.Event;
import com.atlassian.user.User;
import java.util.ArrayList;
import org.apache.log4j.Category;

public class DefaultPersonalInformationManager
extends DefaultContentEntityManager
implements PersonalInformationManager {
    private static Category log = Category.getInstance(DefaultPersonalInformationManager.class);
    private PersonalInformationDao personalInformationDao;
    private AttachmentManager attachmentManager;

    public PersonalInformation getPersonalInformation(String username) {
        return this.getOrCreatePersonalInformation(username);
    }

    public PersonalInformation getPersonalInformation(User user) {
        return this.getOrCreatePersonalInformation(user.getName());
    }

    private PersonalInformation getOrCreatePersonalInformation(String username) {
        PersonalInformation result = this.personalInformationDao.getByUsername(username);
        if (result == null) {
            result = new PersonalInformation();
            result.setUsername(username);
            this.savePersonalInformation(result, null);
        }
        return result;
    }

    public PersonalInformation createPersonalInformation(User user) {
        return this.getOrCreatePersonalInformation(user.getName());
    }

    public void savePersonalInformation(PersonalInformation newInfo, PersonalInformation oldInfo) {
        if (oldInfo != null && !newInfo.getUsername().equals(oldInfo.getUsername())) {
            throw new IllegalArgumentException("Usernames on update do not match. New: " + newInfo.getUsername() + " Old: " + oldInfo.getUsername());
        }
        this.saveContentEntity(newInfo, oldInfo, null);
    }

    public void setPersonalInformationDao(PersonalInformationDao personalInformationDao) {
        this.personalInformationDao = personalInformationDao;
    }

    public void removePersonalInformation(String username) {
        PersonalInformation info = this.getPersonalInformation(username);
        if (info == null) {
            log.error((Object)("Could not retrieve PersonalInformation object for user '" + username + "' for removal."));
            return;
        }
        ArrayList attachments = new ArrayList(info.getLatestVersionsOfAttachments());
        this.attachmentManager.removeAttachments(attachments);
        this.removeContentEntity(info);
    }

    protected void publishCreateEvent(ContentEntityObject obj) {
        this.eventManager.publishEvent((Event)new PersonalInformationCreateEvent(this, (PersonalInformation)obj));
    }

    protected void publishUpdateEvent(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        if (saveContext == null) {
            this.eventManager.publishEvent((Event)new PersonalInformationUpdateEvent(this, (PersonalInformation)obj, (PersonalInformation)origObj));
        } else {
            this.eventManager.publishEvent((Event)new PersonalInformationUpdateEvent(this, (PersonalInformation)obj, (PersonalInformation)origObj, saveContext.isMinorEdit()));
        }
    }

    protected void publishRemoveEvent(ContentEntityObject obj) {
        this.eventManager.publishEvent((Event)new PersonalInformationRemoveEvent(this, (PersonalInformation)obj));
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

