/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.SearchEntitiesManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.search.query.AllRepositoriesQueryContext;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.MultiTermBooleanQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import java.lang.reflect.Constructor;
import java.util.List;

public class DefaultSearchEntitiesManager
implements SearchEntitiesManager {
    private EntityQueryParser entityQueryParser;
    private UserAccessor userAccessor;

    public SearchResult findGroups(TermQuery tQuery) throws EntityException {
        return this.findGroups(tQuery, true);
    }

    public SearchResult findGroups(TermQuery tQuery, boolean filterGroups) throws EntityException {
        AllRepositoriesQueryContext ctx = new AllRepositoriesQueryContext();
        SearchResult result = this.entityQueryParser.findGroups((Query)tQuery, (QueryContext)ctx);
        if (!filterGroups) {
            return result;
        }
        Pager groupList = this.userAccessor.filterUnaccessibleGroups(result.pager(), AuthenticatedUserThreadLocal.getUser());
        return new DefaultSearchResult(groupList, null);
    }

    public SearchResult findUsers(Query query) throws EntityException {
        AllRepositoriesQueryContext ctx = new AllRepositoriesQueryContext();
        SearchResult result = this.entityQueryParser.findUsers(query, (QueryContext)ctx);
        Pager userList = this.userAccessor.filterUnaccessibleUsers(result.pager(), AuthenticatedUserThreadLocal.getUser());
        return new DefaultSearchResult(userList, null);
    }

    public List findGroupsAsList(TermQuery tQuery) throws EntityException {
        return PagerUtils.toList((Pager)this.findGroups(tQuery).pager());
    }

    public List findGroupsAsList(TermQuery tQuery, boolean filterGroups) throws EntityException {
        return PagerUtils.toList((Pager)this.findGroups(tQuery, filterGroups).pager());
    }

    public List findUsersAsList(Query finalQuery) throws EntityException {
        return PagerUtils.toList((Pager)this.findUsers(finalQuery).pager());
    }

    public TermQuery getTermQuery(String term, Class termQueryClass) throws EntityQueryException {
        TermQuery tQuery = null;
        if (term.indexOf("*") == -1) {
            tQuery = this.getTermQueryObject(termQueryClass, term);
        } else if (term.indexOf("*") == 0 && term.lastIndexOf("*") == 0) {
            String copied = term.replaceFirst("\\*", "");
            tQuery = this.getTermQueryObject(termQueryClass, copied, "ends_with");
        } else if (term.indexOf("*") == term.length() - 1) {
            String copied = term.replaceFirst("\\*", "");
            tQuery = this.getTermQueryObject(termQueryClass, copied, "starts_with");
        } else if (term.indexOf("*") == 0 && term.indexOf("*", 1) == term.length() - 1) {
            String copied = term.replaceAll("\\*", "");
            tQuery = this.getTermQueryObject(termQueryClass, copied, "contains");
        } else {
            throw new EntityQueryException("You may only use two wildcards to wrap the search term - e.g. *smith*. Your term was: " + term);
        }
        return tQuery;
    }

    public TermQuery getGroupNameTermQuery(String groupnameTerm) throws EntityQueryException {
        GroupNameTermQuery tQuery = null;
        if (groupnameTerm.indexOf("*") == -1) {
            tQuery = new GroupNameTermQuery(groupnameTerm, "starts_with");
        } else if (groupnameTerm.indexOf("*") == 0 && groupnameTerm.lastIndexOf("*") == 0) {
            String copied = groupnameTerm.replaceFirst("\\*", "");
            tQuery = new GroupNameTermQuery(copied, "ends_with");
        } else if (groupnameTerm.indexOf("*") == groupnameTerm.length() - 1) {
            String copied = groupnameTerm.replaceFirst("\\*", "");
            tQuery = new GroupNameTermQuery(copied, "starts_with");
        } else if (groupnameTerm.indexOf("*") == 0 && groupnameTerm.indexOf("*", 1) == groupnameTerm.length() - 1) {
            String copied = groupnameTerm.replaceAll("\\*", "");
            tQuery = new GroupNameTermQuery(copied, "contains");
        } else {
            throw new EntityQueryException("You may only use two wildcards to wrap the search term - e.g. *smith*. Your term was: " + groupnameTerm);
        }
        return tQuery;
    }

    public Query createUserQuery(List searchTerms, String operator) throws EntityQueryException {
        Query finalQuery;
        if (searchTerms.size() > 1) {
            if (operator == null) {
                throw new EntityQueryException("You must specify a boolean operator ('match all' or 'match any') for a multi-term user search.");
            }
            finalQuery = new MultiTermBooleanQuery((Query[])searchTerms.toArray(new TermQuery[0]), "match all".equals(operator));
        } else if (searchTerms.size() > 0) {
            finalQuery = (Query)searchTerms.get(0);
        } else {
            throw new IllegalArgumentException("No search terms specified");
        }
        return finalQuery;
    }

    private TermQuery getTermQueryObject(Class termQueryClass, String term) throws EntityQueryException {
        TermQuery termQuery;
        try {
            Constructor constructor = termQueryClass.getConstructor(String.class);
            termQuery = (TermQuery)constructor.newInstance(term);
        }
        catch (Exception e) {
            throw new EntityQueryException((Throwable)e);
        }
        return termQuery;
    }

    private TermQuery getTermQueryObject(Class termQueryClass, String term, String condition) throws EntityQueryException {
        TermQuery termQuery = null;
        try {
            Constructor constructor = termQueryClass.getConstructor(String.class, String.class);
            termQuery = (TermQuery)constructor.newInstance(term, condition);
        }
        catch (Exception e) {
            throw new EntityQueryException((Throwable)e);
        }
        return termQuery;
    }

    public void setEntityQueryParser(EntityQueryParser entityQueryParser) {
        this.entityQueryParser = entityQueryParser;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

