/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.xwork.ActionContext;
import java.util.Map;
import org.apache.log4j.Category;

public class UserInterfaceState {
    private static Category log = Category.getInstance(UserInterfaceState.class);
    public static final int DEFAULT_MAX_RECENTLY_ADDED_PAGE_COUNT = 10;
    public static final int DEFAULT_MAX_RECENTLY_UPDATED_PAGE_COUNT = 10;
    public static final int LIMIT_RECENTLY_ADDED_PAGE_COUNT = 50;
    public static final int LIMIT_MAX_RECENTLY_UPDATED_PAGE_COUNT = 50;
    public static final String DEFAULT_DASHBOARD_TAB = "my";
    private User user;
    private Boolean commentsShowing;
    private Boolean attachmentsShowing;
    private Boolean childrenShowing;
    private Boolean restrictionsShowing;
    private Boolean labelsShowing;
    private int recentChangesSize;
    private UserAccessor userAccessor;

    public UserInterfaceState(User user) {
        this.user = user;
        this.userAccessor = this.getUserAccessor();
    }

    private UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public UserInterfaceState(User user, UserAccessor userAccessor) {
        this.user = user;
        this.userAccessor = userAccessor;
    }

    public Boolean getCommentsShowing() {
        if (this.commentsShowing == null) {
            this.commentsShowing = this.getBooleanFromSessionOrUserPrefs("confluence.show.comments", "confluence.user.runtime.show-comments");
        }
        return this.commentsShowing;
    }

    public void setCommentsShowing(Boolean commentsShowing) {
        this.setBooleanInSessionAndUserPrefs(commentsShowing, "confluence.show.comments", "confluence.user.runtime.show-comments");
    }

    public Boolean getAttachmentsShowing() {
        if (this.attachmentsShowing == null) {
            this.attachmentsShowing = this.getBooleanFromSessionOrUserPrefs("confluence.show.attachments", "confluence.user.runtime.show-attachments");
        }
        return this.attachmentsShowing;
    }

    public void setAttachmentsShowing(Boolean attachmentsShowing) {
        this.setBooleanInSessionAndUserPrefs(attachmentsShowing, "confluence.show.attachments", "confluence.user.runtime.show-attachments");
    }

    public Boolean getChildrenShowing() {
        if (this.childrenShowing == null) {
            this.childrenShowing = this.getBooleanFromSessionOrUserPrefs("confluence.show.children", "confluence.user.runtime.show-children");
        }
        return this.childrenShowing;
    }

    public void setChildrenShowing(Boolean childrenShowing) {
        this.setBooleanInSessionAndUserPrefs(childrenShowing, "confluence.show.children", "confluence.user.runtime.show-children");
    }

    public void setRecentChangesSize(int recentChangesSize) {
        this.setIntInSessionAndUserPrefs(recentChangesSize, "confluence.recentchanges.size", "confluence.user.runtime.recent-changes.size");
    }

    public void setDashboardTab(String dashboardTab) {
        this.setStringInSessionAndUserPrefs(dashboardTab, "confluence.dashboard.spaces.selected.tab", "confluence.user.dashboard.spaces.selected.tab");
    }

    public String getDashboardTab() {
        return this.getStringFromSessionOrUserPrefs("confluence.dashboard.spaces.selected.tab", "confluence.user.dashboard.spaces.selected.tab");
    }

    public void setDashboardSpacesSelectedTeam(String selectedTeam) {
        this.setStringInSessionAndUserPrefs(selectedTeam, "confluence.dashboard.spaces.selected.team", "confluence.user.dashboard.spaces.selected.team");
    }

    public String getDashboardSpacesSelectedTeam() {
        return this.getStringFromSessionOrUserPrefs("confluence.dashboard.spaces.selected.team", "confluence.user.dashboard.spaces.selected.team");
    }

    public void setDashboardSpacesSelectedGroup(String selectedGroup) {
        this.setStringInSessionAndUserPrefs(selectedGroup, "confluence.dashboard.spaces.selected.group", "confluence.user.dashboard.spaces.selected.group");
    }

    public String getDashboardSpacesSelectedGroup() {
        return this.getStringFromSessionOrUserPrefs("confluence.dashboard.spaces.selected.group", "confluence.user.dashboard.spaces.selected.group");
    }

    public int getRecentChangesSize() {
        if (this.recentChangesSize == 0) {
            this.recentChangesSize = this.getIntegerFromSessionOrUserPrefs("confluence.recentchanges.size", "confluence.user.runtime.recent-changes.size");
        }
        return this.recentChangesSize;
    }

    private void setBooleanInSessionAndUserPrefs(Boolean value, String sessionKey, String userPrefsKey) {
        this.putInSession(sessionKey, value);
        this.setBooleanUserPref(userPrefsKey, value);
    }

    private Boolean getBooleanFromSessionOrUserPrefs(String sessionKey, String userPrefsKey) {
        Boolean b = (Boolean)this.getFromSession(sessionKey);
        if (b == null) {
            b = this.user != null ? Boolean.valueOf(this.userAccessor.getPropertySet(this.user).getBoolean(userPrefsKey)) : Boolean.TRUE;
        }
        return b;
    }

    private void setBooleanUserPref(String key, Boolean value) {
        if (this.user != null) {
            this.userAccessor.getPropertySet(this.user).setBoolean(key, value.booleanValue());
        }
    }

    private void setIntInSessionAndUserPrefs(int value, String sessionKey, String userPrefsKey) {
        this.putInSession(sessionKey, new Integer(value));
        this.setIntegerUserPref(userPrefsKey, value);
    }

    private int getIntegerFromSessionOrUserPrefs(String sessionKey, String userPrefsKey) {
        Integer i = (Integer)this.getFromSession(sessionKey);
        if (i == null && this.user != null) {
            return this.userAccessor.getPropertySet(this.user).getInt(userPrefsKey);
        }
        return i == null ? 0 : i;
    }

    private void setIntegerUserPref(String key, int value) {
        if (this.user != null) {
            this.userAccessor.getPropertySet(this.user).setInt(key, value);
        }
    }

    private String getStringFromSessionOrUserPrefs(String sessionKey, String userPrefsKey) {
        String s = (String)this.getFromSession(sessionKey);
        if (s == null && this.user != null) {
            return this.userAccessor.getPropertySet(this.user).getString(userPrefsKey);
        }
        return s;
    }

    private void setStringUserPref(String key, String value) {
        if (this.user != null) {
            this.userAccessor.getPropertySet(this.user).setString(key, value);
        }
    }

    private void setStringInSessionAndUserPrefs(String value, String sessionKey, String userPrefsKey) {
        this.putInSession(sessionKey, value);
        this.setStringUserPref(userPrefsKey, value);
    }

    private Object getFromSession(String sessionKey) {
        Map session = ActionContext.getContext().getSession();
        if (session != null) {
            return session.get(sessionKey);
        }
        log.warn((Object)"Unable to retrieve preference from session: session not available");
        return null;
    }

    private void putInSession(String sessionKey, Object value) {
        Map session = ActionContext.getContext().getSession();
        if (session != null) {
            session.put(sessionKey, value);
        } else {
            log.warn((Object)"Unable to save preference in session: session not available");
        }
    }

    public int getMaxRecentChangesSize() {
        int i = this.getRecentChangesSize();
        if (i < 10) {
            return 10;
        }
        if (i > 50) {
            return 50;
        }
        return i;
    }

    public void setMaxRecentChangesSize(int i) {
        if (i < 10) {
            i = 10;
        } else if (i > 50) {
            i = 50;
        }
        this.setRecentChangesSize(i);
    }

    public Boolean getLocationShowing() {
        return false;
    }

    public void setLocationShowing(Boolean locationShowing) {
    }

    public Boolean getRestrictionsShowing() {
        if (this.restrictionsShowing == null) {
            this.restrictionsShowing = this.getBooleanFromSessionOrUserPrefs("confluence.edit.show.restrictions", "confluence.user.runtime.edit.show-restrictios");
        }
        return this.restrictionsShowing;
    }

    public void setRestrictionsShowing(Boolean restrictionsShowing) {
        this.setBooleanInSessionAndUserPrefs(restrictionsShowing, "confluence.edit.show.restrictions", "confluence.user.runtime.edit.show-restrictios");
    }

    public Boolean getLabelsShowing() {
        if (this.labelsShowing == null) {
            this.labelsShowing = this.getBooleanFromSessionOrUserPrefs("confluence.edit.show.labels", "confluence.user.runtime.edit.show-labels");
        }
        return this.labelsShowing;
    }

    public void setLabelsShowing(Boolean labelsShowing) {
        this.setBooleanInSessionAndUserPrefs(labelsShowing, "confluence.edit.show.labels", "confluence.user.runtime.edit.show-labels");
    }
}

