/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class UsernameToUserTranslatingPaginationSupport
extends PaginationSupport {
    private static Logger log = Logger.getLogger(UsernameToUserTranslatingPaginationSupport.class);
    UserAccessor userAccessor;

    public UsernameToUserTranslatingPaginationSupport(int pageSize, int startIndexValue) {
        super(pageSize);
        this.setStartIndex(startIndexValue);
    }

    public List getPage() {
        List usernames = super.getPage();
        if (usernames == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> users = new ArrayList<Object>(usernames.size());
        for (String username : usernames) {
            User user;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving user with username: " + username));
            }
            if ((user = this.userAccessor.getUser(username)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found user: [class=" + user.getClass() + ",name=" + user.getName() + ",fullName=" + user.getFullName() + ",email=" + user.getEmail() + "]"));
                }
                users.add(user);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find a user for username: " + username + ". This username will be displayed as is."));
            }
            users.add(new DefaultUser(username));
        }
        return users;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

