/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.license.LicenseManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;

public abstract class AbstractUsersAction
extends ConfluenceActionSupport
implements Administrative {
    protected String username;
    public User user;

    public boolean isAllowedToAddUsers() {
        int totalSize = this.userAccessor.getUsersWithConfluenceAccessAsList().size();
        return LicenseManager.getInstance().getLicense("CONF").getUsers() > totalSize;
    }

    public User getUser() {
        if (this.username == null) {
            return null;
        }
        if (this.user == null) {
            this.user = this.userAccessor.getUser(this.username);
        }
        if (this.user == null) {
            this.user = this.userAccessor.getUser(GeneralUtil.urlDecode(this.username));
        }
        if (this.user == null) {
            this.user = this.userAccessor.getUser(this.username.toLowerCase());
        }
        return this.user;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (GeneralUtil.shouldUrlDecode(username)) {
            username = GeneralUtil.urlDecode(username);
        }
        this.username = TextUtils.stringSet((String)username) ? username.trim() : username;
    }

    public String getRemoteUsername() {
        return ServletActionContext.getRequest().getRemoteUser();
    }
}

