/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import bucket.core.actions.PagerPaginationSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.actions.AbstractGroupAction;
import com.atlassian.user.Group;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.osuser.OSUGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BrowseGroupsAction
extends AbstractGroupAction {
    protected static final int GROUPS_PER_PAGE = 25;
    protected PagerPaginationSupport paginationSupport;
    protected int startIndex;

    public void validate() {
        super.validate();
        if (this.getName() != null && !this.getName().equals(this.getName().toLowerCase())) {
            this.addFieldError("name", this.getText("group.name.lowercase"));
        }
    }

    public String doAdd() throws Exception {
        if ("confluence-administrators".equals(this.name) && !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
            this.addActionError("You do not have permissions to add the " + this.name + " group.");
            return "error";
        }
        this.userAccessor.createGroup(this.name);
        return "success";
    }

    public PagerPaginationSupport getPaginationSupport() {
        if (this.paginationSupport == null) {
            this.paginationSupport = new GroupsPaginationSupport(25);
            this.paginationSupport.setStartIndex(this.startIndex);
            this.paginationSupport.setItems(this.getGroups());
        }
        return this.paginationSupport;
    }

    public boolean canRemove(Group group) {
        return this.isRemovable(group) && this.permissionManager.hasPermission(this.getRemoteUser(), Permission.REMOVE, group);
    }

    public boolean isRemovable(Group group) {
        return group instanceof DefaultHibernateGroup || group instanceof OSUGroup || !this.userAccessor.isReadOnly(group);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    private class GroupsPaginationSupport
    extends PagerPaginationSupport {
        public GroupsPaginationSupport(int i) {
            super(i);
        }

        public List getPage() {
            List names = super.getPage();
            if (names == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> groups = new ArrayList<Object>(names.size());
            for (Object name : names) {
                if (name instanceof String) {
                    groups.add(BrowseGroupsAction.this.userAccessor.getGroup((String)name));
                    continue;
                }
                groups.add(name);
            }
            return groups;
        }
    }
}

