/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.util.PairType;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EditMyPreferencesAction
extends AbstractUserProfileAction {
    public String doEdit() throws AtlassianCoreException {
        this.updateUserPreferences();
        return this.getFieldErrors().size() > 0 ? "input" : "success";
    }

    public void validate() {
        super.validate();
        Language language = null;
        if (TextUtils.stringSet((String)this.preferredUserLocale)) {
            language = this.languageManager.getLanguage(this.preferredUserLocale);
        }
        if (language != null && !language.isLicensed()) {
            this.addActionError(this.getText("language.not.licensed"));
        }
    }

    protected void updateUserPreferences() throws AtlassianCoreException {
        if ("".equals(this.siteHomePage)) {
            try {
                this.getUserPreferences().remove("confluence.user.site.homepage");
            }
            catch (AtlassianCoreException e) {}
        } else {
            this.getUserPreferences().setString("confluence.user.site.homepage", this.siteHomePage);
        }
        this.getUserPreferences().setString("confluence.user.dashboard.labels", this.dashboardLabels);
        String userLocale = this.getUserPreferences().getString("confluence.user.locale");
        if (this.preferredUserLocale.equals("None")) {
            if (userLocale != null) {
                this.getUserPreferences().remove("confluence.user.locale");
            }
        } else {
            this.getUserPreferences().setString("confluence.user.locale", this.preferredUserLocale.trim());
        }
        this.userAccessor.getConfluenceUserPreferences(this.getUser()).setTimeZone(this.getUserTimeZone());
    }

    public List getSiteHomePages() {
        ArrayList<PairType> siteHomePages = new ArrayList<PairType>();
        siteHomePages.add(new PairType((Serializable)((Object)"dashboard"), (Serializable)((Object)this.getText("dashboard.name"))));
        siteHomePages.add(new PairType((Serializable)((Object)"siteHomepage"), (Serializable)((Object)this.getText("homepage.default", new String[]{this.getGlobalHomepageSetting()}))));
        siteHomePages.add(new PairType((Serializable)((Object)"profile"), (Serializable)((Object)this.getText("selection.your.profile"))));
        ArrayList<Space> visibleSpaces = new ArrayList<Space>();
        Space personalSpace = this.spaceManager.getPersonalSpace(this.getRemoteUser());
        if (personalSpace != null) {
            visibleSpaces.add(personalSpace);
        }
        visibleSpaces.addAll(this.spaceManager.getPermittedSpacesByType(this.getRemoteUser(), SpaceType.GLOBAL));
        for (int i = 0; i < visibleSpaces.size(); ++i) {
            Space space = (Space)visibleSpaces.get(i);
            siteHomePages.add(new PairType((Serializable)((Object)space.getKey()), (Serializable)((Object)(space.getName() + " (" + space.getKey() + ")"))));
        }
        return siteHomePages;
    }

    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }

    public String getSiteHomePage() {
        String s = super.getSiteHomePage();
        if ("".equals(s)) {
            return "siteHomepage";
        }
        return s;
    }

    public List getAvailableTimeZones() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        TimeZone defaultTimeZone = this.settingsManager.getGlobalSettings().getTimeZone();
        result.add(new PairType((Serializable)((Object)defaultTimeZone.getID()), (Serializable)((Object)this.defaultTimeZoneCaption(defaultTimeZone))));
        List timeZones = TimeZone.getSortedTimeZones();
        for (TimeZone tz : timeZones) {
            if (tz.equals(defaultTimeZone)) continue;
            result.add(new PairType((Serializable)((Object)tz.getID()), (Serializable)((Object)this.timeZoneCaption(tz))));
        }
        return result;
    }

    private String defaultTimeZoneCaption(TimeZone defaultTimeZone) {
        return this.getText("time.zone.server.default", new Object[]{this.timeZoneCaption(defaultTimeZone)});
    }

    private String timeZoneCaption(TimeZone timeZone) {
        String key = timeZone.getMessageKey();
        if (key.equals(this.getText(key))) {
            return timeZone.getID();
        }
        return this.getText("time.zone.caption", new Object[]{timeZone.getDisplayOffset(), this.getText(key)});
    }
}

