/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;

public class EditMyProfileAction
extends AbstractUserProfileAction
implements CaptchaAware {
    private CaptchaManager captchaManager;
    private boolean fullNameHasChanged = false;

    public void validate() {
        super.validate();
        if (this.getText("anonymous.name").equalsIgnoreCase(this.getFullName())) {
            this.addFieldError("fullName", this.getText("reserved.fullname"));
        } else if ("anonymous".equalsIgnoreCase(this.getFullName())) {
            this.addFieldError("fullName", this.getText("reserved.fullname"));
        }
    }

    public String doEdit() throws Exception {
        if (!this.settingsManager.getGlobalSettings().isExternalUserManagement() && !this.userAccessor.isReadOnly(this.getUser())) {
            this.updateUser();
        }
        this.updatePersonalInformation();
        if (this.getFieldErrors().size() > 0) {
            return "input";
        }
        return "success";
    }

    private void updateUser() {
        if (this.fullName != null && !this.fullName.trim().equals(this.getUser().getFullName())) {
            this.fullNameHasChanged = true;
        }
        this.getUser().setFullName(this.fullName.trim());
        this.getUser().setEmail(this.email);
        this.userAccessor.saveUser(this.getUser());
    }

    private void updatePersonalInformation() throws CloneNotSupportedException {
        PersonalInformation oldInfo;
        PersonalInformation newInfo = this.getPersonalInformationEntity();
        try {
            oldInfo = (PersonalInformation)newInfo.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion Failure");
        }
        newInfo.setContent(this.getPersonalInformation().trim());
        newInfo.setFullName(this.getFullName());
        if (this.shouldUpdatePersonalInfo(oldInfo, newInfo)) {
            this.personalInformationManager.savePersonalInformation(newInfo, oldInfo);
        }
    }

    private boolean shouldUpdatePersonalInfo(PersonalInformation oldInfo, PersonalInformation newInfo) {
        return oldInfo == null || !newInfo.getContent().equals(oldInfo.getContent()) || this.fullNameHasChanged;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }
}

