/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.util.ProfilePicture;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.xwork.FileUploadUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditMyProfilePictureAction
extends AbstractUserProfileAction {
    private static final Logger log = Logger.getLogger(EditMyProfilePictureAction.class);
    private static final String NO_PICTURE = "__NONE__";
    private String userProfilePictureName;
    private List<ProfilePictureInfo> uploadedProfilePictures;
    private String upload;
    private List<ProfilePictureInfo> standardProfilePictures;
    private FileUploadManager fileUploadManager;

    public String doEdit() throws Exception {
        try {
            this.updateProfilePicture();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.info((Object)("Upload error: " + e.getMessage()), (Throwable)e);
            this.addFieldError("userProfilePictureName", this.getText("upload.failed", new String[]{e.getMessage()}));
        }
        if (this.getFieldErrors().size() > 0) {
            return "input";
        }
        return "success";
    }

    public List<Attachment> getImageAttachments() {
        if (this.getPersonalInformationEntity() == null) {
            return Collections.emptyList();
        }
        List<Attachment> attachments = this.attachmentManager.getLatestVersionsOfAttachments(this.getPersonalInformationEntity());
        ArrayList<Attachment> imageAttachments = new ArrayList<Attachment>(attachments.size());
        for (Attachment attachment : attachments) {
            if (!attachment.getContentType().toLowerCase().startsWith("image/")) continue;
            imageAttachments.add(attachment);
        }
        return imageAttachments;
    }

    public List<ProfilePictureInfo> getUploadedProfilePictures() {
        if (this.uploadedProfilePictures == null) {
            List<Attachment> imageAttachments = this.getImageAttachments();
            this.uploadedProfilePictures = new ArrayList<ProfilePictureInfo>(imageAttachments.size());
            for (Attachment attachment : imageAttachments) {
                this.uploadedProfilePictures.add(new ProfilePictureInfo(attachment));
            }
        }
        return this.uploadedProfilePictures;
    }

    public List<ProfilePictureInfo> getStandardProfilePictures() {
        if (this.standardProfilePictures == null) {
            Set userIcons = ServletContextThreadLocal.getContext().getResourcePaths("/images/icons/profilepics/");
            CollectionUtils.filter((Collection)userIcons, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    String s = (String)object;
                    return s.endsWith(".gif") && !s.endsWith("default.gif");
                }
            });
            this.standardProfilePictures = new ArrayList<ProfilePictureInfo>(userIcons.size());
            for (String path : userIcons) {
                this.standardProfilePictures.add(new ProfilePictureInfo(path));
            }
        }
        return this.standardProfilePictures;
    }

    private void getPicturePropertyFromUploadedPicture() throws FileUploadUtils.FileUploadException, IOException, AtlassianCoreException {
        String uploadedAttachmentName = this.handlePictureUpload();
        if (uploadedAttachmentName != null) {
            this.getUserPreferences().setString("confluence.user.profile.picture", uploadedAttachmentName);
        } else {
            this.removePictureProperty();
        }
    }

    private void updateProfilePicture() throws AtlassianCoreException, FileUploadUtils.FileUploadException, IOException {
        if (this.upload != null) {
            this.getPicturePropertyFromUploadedPicture();
        } else {
            this.getUserPreferences().setString("confluence.user.profile.picture", this.getUserProfilePictureName());
        }
    }

    public void setUpload(String s) {
        this.upload = s;
    }

    private String handlePictureUpload() throws FileUploadUtils.FileUploadException, IOException {
        FileUploadUtils.UploadedFile uploadedFile = FileUploadUtils.getSingleUploadedFile();
        if (uploadedFile == null) {
            this.addFieldError("userProfilePictureName", this.getText("no.picture.uploaded"));
            return null;
        }
        if (!uploadedFile.getContentType().toLowerCase().startsWith("image/")) {
            this.addFieldError("userProfilePictureName", this.getText("not.an.image", new String[]{uploadedFile.getContentType()}));
            return null;
        }
        this.storeAttachment(this.getPersonalInformationEntity(), uploadedFile, "Uploaded Profile Picture");
        return uploadedFile.getFileName().toLowerCase();
    }

    private void storeAttachment(PersonalInformation personalInfo, FileUploadUtils.UploadedFile uploadedFile, String comment) throws IOException {
        File resizedProfilePicture;
        String fileName = uploadedFile.getFileName().toLowerCase();
        ProfilePicture profilePicture = new ProfilePicture(new FileInputStream(uploadedFile.getFile()), fileName);
        File imageFileToUse = resizedProfilePicture = profilePicture.create();
        if (resizedProfilePicture == null) {
            log.warn((Object)"User's profile image could not be resized.  Using uncropped image instead.");
            imageFileToUse = uploadedFile.getFile();
        }
        this.fileUploadManager.storeFile(new FileUploadUtils.UploadedFile(imageFileToUse, fileName, uploadedFile.getContentType()), comment, personalInfo);
        personalInfo.addAttachment(this.attachmentManager.getAttachment(personalInfo, fileName));
    }

    private void removePictureProperty() {
        try {
            this.getUserPreferences().remove("confluence.user.profile.picture");
        }
        catch (AtlassianCoreException atlassianCoreException) {
            // empty catch block
        }
    }

    public String getUserProfilePictureName() {
        if (this.userProfilePictureName == null) {
            ProfilePictureInfo userProfilePicture = this.getUserProfilePicture();
            this.userProfilePictureName = userProfilePicture == null ? NO_PICTURE : userProfilePicture.getFileName();
        }
        return this.userProfilePictureName;
    }

    public void setUserProfilePictureName(String userProfilePictureName) {
        this.userProfilePictureName = userProfilePictureName;
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }
}

