/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.security.ExternalUserManagementAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.List;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class EditUserGroupsAction
extends AbstractUsersAction
implements ExternalUserManagementAware {
    private static final Logger log = Logger.getLogger(EditUserGroupsAction.class);
    protected List memberGroups;
    protected List nonMemberGroups;
    protected String action;
    protected List groupsToJoin;
    protected List groupsToLeave;
    protected List readOnlyGroups = new ArrayList();
    protected PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache;

    public void setPermissionCheckDispatcherResultCache(PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache) {
        this.permissionCheckDispatcherResultCache = permissionCheckDispatcherResultCache;
    }

    public String doDefault() throws Exception {
        if (this.getUser() == null) {
            this.addActionError(this.getText("no.such.user.exists", new String[]{this.username}));
        } else {
            this.loadLists();
        }
        return super.doDefault();
    }

    private void loadLists() {
        UtilTimerStack.push((String)"loadLists");
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)("Getting groups for user " + (this.getUser() == null ? "Anonymous" : this.getUser().getName())));
        }
        this.loadMemberGroups();
        this.loadNonMemberGroups(this.memberGroups);
        UtilTimerStack.pop((String)"loadLists");
    }

    private void loadMemberGroups() {
        this.memberGroups = new ArrayList();
        for (Group group : this.userAccessor.getGroups(this.getUser())) {
            if (this.userAccessor.isReadOnly(group)) {
                this.readOnlyGroups.add(group.getName());
                continue;
            }
            this.memberGroups.add(group.getName());
        }
    }

    private void loadNonMemberGroups(List groupsToExclude) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)("Getting groups for user " + (this.getUser() == null ? "Anonymous" : this.getUser().getName())));
        }
        UtilTimerStack.push((String)"Getting all writable groups");
        List allGroups = this.userAccessor.getWriteableGroups();
        this.nonMemberGroups = new ArrayList();
        for (Group g : allGroups) {
            if (groupsToExclude.contains(g.getName())) continue;
            this.nonMemberGroups.add(g.getName());
        }
        UtilTimerStack.pop((String)"Getting all writable groups");
    }

    public String execute() throws Exception {
        if (this.getUser() == null) {
            return "redirect_to_admin";
        }
        if ("join".equalsIgnoreCase(this.action) && this.groupsToJoin != null) {
            for (String groupname : this.groupsToJoin) {
                Group group = this.userAccessor.getGroup(groupname);
                if (group == null || this.userAccessor.hasMembership(groupname, this.getUser().getName())) continue;
                if (this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, group)) {
                    this.userAccessor.addMembership(group, this.getUser());
                    continue;
                }
                this.addActionError("cannot.modify.group.membership", new String[]{this.getUser().getName(), group.getName()});
            }
        } else if ("leave".equalsIgnoreCase(this.action) && this.groupsToLeave != null) {
            String remoteUserName = this.getRemoteUser().getName();
            boolean adminEditingSelf = remoteUserName.equals(this.getUsername());
            for (String groupname : this.groupsToLeave) {
                Group group = this.userAccessor.getGroup(groupname);
                if (group == null || !this.userAccessor.hasMembership(group.getName(), this.getUser().getName())) continue;
                if (adminEditingSelf && (this.isLastGroup(groupname, "SYSTEMADMINISTRATOR") || this.isLastGroup(groupname, "USECONFLUENCE"))) {
                    this.addActionError(this.getText("error.leave.admin.group"));
                    this.loadLists();
                    return "input";
                }
                if (this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, group)) {
                    this.userAccessor.removeMembership(group, this.getUser());
                    continue;
                }
                this.addActionError("cannot.modify.group.membership", new String[]{this.getUser().getName(), group.getName()});
            }
        }
        this.refreshPermissionCheckDispatcherResultCache();
        if (ContainerManager.getInstance().getContainerContext() != null) {
            try {
                SessionFactory factory = (SessionFactory)ContainerManager.getInstance().getContainerContext().getComponent((Object)"sessionFactory");
                Session session = SessionFactoryUtils.getSession((SessionFactory)factory, (boolean)false);
                session.flush();
            }
            catch (ComponentNotFoundException e) {
                log.error((Object)"Unable to flush session", (Throwable)e);
            }
        }
        this.loadLists();
        if (this.getActionErrors().isEmpty()) {
            return super.execute();
        }
        return "error";
    }

    private void refreshPermissionCheckDispatcherResultCache() {
        if (this.permissionCheckDispatcherResultCache != null && this.getUser() != null) {
            this.permissionCheckDispatcherResultCache.removeFromCache(this.getUser().getName());
        }
    }

    protected boolean isLastGroup(String group, String permission) {
        ArrayList<String> permissionGroups = new ArrayList<String>();
        for (SpacePermission spacePermission : this.spacePermissionManager.getGlobalPermissions()) {
            if (!spacePermission.getType().equals(permission) || !spacePermission.isGroupPermission() || !this.userAccessor.hasMembership(spacePermission.getGroup(), this.getRemoteUser().getName())) continue;
            permissionGroups.add(spacePermission.getGroup());
        }
        return permissionGroups.contains(group) && permissionGroups.size() == 1;
    }

    public List getMemberGroups() {
        return this.memberGroups;
    }

    public List getNonMemberGroups() {
        return this.nonMemberGroups;
    }

    public void setGroupsToJoin(List toJoin) {
        this.groupsToJoin = toJoin;
    }

    public void setGroupsToLeave(List toLeave) {
        this.groupsToLeave = toLeave;
    }

    public void setJoin(String action) {
        this.action = "join";
    }

    public void setLeave(String x) {
        this.action = "leave";
    }

    public List getReadOnlyGroups() {
        return this.readOnlyGroups;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

