/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.user.User;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class ForgotUserPasswordAction
extends ConfluenceActionSupport {
    private Random rand = new Random(new Date().getTime());
    private String username;
    private MultiQueueTaskManager taskManager;

    public void validate() {
        super.validate();
        if (!this.isMailServerConfigured()) {
            this.addActionError(this.getText("forgot.pass.nomailserver"));
        }
        if (StringUtils.isBlank((String)this.getUsername())) {
            this.addFieldError("username", this.getText("error.username.required.field"));
        } else {
            User user1 = this.getUser();
            if (user1 == null) {
                this.addFieldError("username", this.getText("forgotpass.user.doesnt.exist"));
            } else {
                if (this.userAccessor.isReadOnly(user1)) {
                    this.addFieldError("username", this.getText("error.password.immutable"));
                }
                if (StringUtils.isBlank((String)user1.getEmail())) {
                    this.addFieldError("username", this.getText("error.user.has.no.email"));
                }
            }
        }
    }

    public String execute() throws Exception {
        String newPassword = this.generateNewPassword();
        User user = this.getUser();
        this.userAccessor.alterPassword(user, newPassword);
        PreRenderedMailNotificationQueueItem queueItem = (PreRenderedMailNotificationQueueItem)PreRenderedMailNotificationQueueItem.createFromTemplateFile(user, "forgotuserpassword-notification.vm", this.getText("forgot.pass.subject"));
        queueItem.addVelocityContextParam("action", this);
        queueItem.addVelocityContextParam("newPassword", newPassword);
        queueItem.render();
        this.taskManager.addTask("mail", (Task)queueItem);
        return "success";
    }

    private String generateNewPassword() {
        StringBuffer pass = new StringBuffer();
        int pass_len = this.rand.nextInt(6) + 5;
        for (int i = 0; i < pass_len; ++i) {
            pass.append(this.generateRandomCharacter());
        }
        return pass.toString();
    }

    private char generateRandomCharacter() {
        int[] characterRange = this.getRandomCharacterRange();
        return (char)(this.rand.nextInt(characterRange[1] - characterRange[0]) + characterRange[0]);
    }

    private int[] getRandomCharacterRange() {
        int set_no = this.rand.nextInt(3);
        switch (set_no) {
            case 0: {
                return new int[]{65, 90};
            }
            case 1: {
                return new int[]{97, 122};
            }
            case 2: {
                return new int[]{48, 57};
            }
        }
        return null;
    }

    public User getUser() {
        return this.userAccessor.getUser(this.username);
    }

    public boolean isMailServerConfigured() {
        return GeneralUtil.isOutgoingMailConfigured();
    }

    public boolean isPermitted() {
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }
}

