/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.SearchEntitiesManager;
import com.atlassian.confluence.user.actions.AbstractEntityPaginationAction;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.core.util.filter.Filter;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.TermQuery;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Category;

public class GroupPickerAction
extends AbstractEntityPaginationAction {
    private static Category log = Category.getInstance(GroupPickerAction.class);
    private String key;
    private String actionName;
    private String existingGroups;
    private Collection groups;
    private long pageId;
    private List excludedGroups = new ArrayList();
    private String onPopupSubmit;
    private String groupnameTerm;
    private SpaceManager spaceManager;
    private SearchEntitiesManager searchEntitiesManager;

    public String doGroupSearch() {
        TermQuery termQuery = null;
        if (TextUtils.stringSet((String)this.groupnameTerm)) {
            try {
                termQuery = this.searchEntitiesManager.getGroupNameTermQuery(this.groupnameTerm);
            }
            catch (EntityQueryException e) {
                this.addActionError(e.getMessage());
            }
        }
        if (termQuery == null) {
            this.addActionError(this.getText("must.specify.search.term"));
            return "error";
        }
        try {
            List result = this.searchEntitiesManager.findGroupsAsList(termQuery);
            this.paginationSupport.setItems(result);
            List groupList = this.paginationSupport.getPage();
            this.setGroups(groupList != null ? groupList : Collections.EMPTY_LIST);
        }
        catch (EntityException e) {
            log.error((Object)("Unable to perform group search : " + e.getMessage()), (Throwable)e);
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String doGroupSearchFilterExistingGroups() {
        this.doGroupSearch();
        FilterChain filter = new FilterChain();
        filter.addFilter(new ExistingGroupsFilter(this.existingGroups));
        this.setGroups(this.filterContent(this.paginationSupport.getPage(), filter));
        return "success";
    }

    public String doFilterAlreadyPermittedGroupSearch() {
        if (!TextUtils.stringSet((String)this.groupnameTerm)) {
            this.groupnameTerm = "*";
        }
        this.doGroupSearch();
        FilterChain filter = new FilterChain();
        filter.addFilter(new GroupsWithPermissionFilter(this.getKey(), this.spaceManager));
        this.setGroups(this.filterContent(this.paginationSupport.getPage(), filter));
        return "success";
    }

    private List filterContent(Collection groups, FilterChain filter) {
        if (groups == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList filteredList = new ArrayList();
        for (Object obj : groups) {
            if (filter.isIncluded(obj)) {
                filteredList.add(obj);
                continue;
            }
            this.excludedGroups.add(obj);
        }
        return filteredList;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public void setGroups(Collection groups) {
        this.groups = groups;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public List getExcludedGroups() {
        return this.excludedGroups;
    }

    public String getCommaSeparatedExcludedGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>(this.excludedGroups.size());
        for (Group group : this.excludedGroups) {
            groupNames.add(group.getName());
        }
        return TextUtils.join((String)", ", groupNames);
    }

    public String getExistingGroups() {
        return this.existingGroups;
    }

    public void setExistingGroups(String existingGroups) {
        this.existingGroups = existingGroups;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String getOnPopupSubmit() {
        return this.onPopupSubmit;
    }

    public void setOnPopupSubmit(String onPopupSubmit) {
        this.onPopupSubmit = onPopupSubmit;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSearchEntitiesManager(SearchEntitiesManager searchEntitiesManager) {
        this.searchEntitiesManager = searchEntitiesManager;
    }

    public String getGroupnameTerm() {
        return this.groupnameTerm;
    }

    public void setGroupnameTerm(String groupnameTerm) {
        this.groupnameTerm = groupnameTerm;
    }

    private class ExistingGroupsFilter
    implements Filter {
        private List existingGroupsList;

        public ExistingGroupsFilter(String existingGroups) {
            this.existingGroupsList = LabelUtil.split(existingGroups);
        }

        public boolean isIncluded(Object object) {
            if (object instanceof Group) {
                Group group = (Group)object;
                return !this.existingGroupsList.contains(group.getName());
            }
            return false;
        }
    }

    private class GroupsWithPermissionFilter
    implements Filter {
        private String spaceKey;
        private SpaceManager spaceManager;

        public GroupsWithPermissionFilter(String spaceKey, SpaceManager spaceManager) {
            this.spaceKey = spaceKey;
            this.spaceManager = spaceManager;
        }

        public boolean isIncluded(Object object) {
            if (object instanceof Group) {
                Group group;
                Space space = this.spaceManager.getSpace(this.spaceKey);
                Collection spaceGroups = GroupPickerAction.this.spacePermissionManager.getGroupsWithPermissions(space);
                return !spaceGroups.contains(group = (Group)object);
            }
            return true;
        }
    }

    private class FilterChain
    implements Filter {
        List filterList = new ArrayList();

        private FilterChain() {
        }

        public void addFilter(Filter filter) {
            this.filterList.add(filter);
        }

        public boolean isIncluded(Object o) {
            for (int i = 0; i < this.filterList.size(); ++i) {
                Filter filter = (Filter)this.filterList.get(i);
                if (filter.isIncluded(o)) continue;
                return false;
            }
            return true;
        }
    }
}

