/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.core.util.WebRequestUtils;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.filter.LoginFilter;
import com.atlassian.upgrade.UpgradeManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.app.FieldMethodizer;

public class LoginAction
extends ConfluenceActionSupport {
    private UpgradeManager upgradeManager = null;
    private boolean fromNotPermitted = false;
    private boolean redirectAfterPost = true;
    private String os_username;
    private String os_destination;

    public String execute() throws Exception {
        ServletActionContext.getContext().getSession().remove(SecurityConfigFactory.getInstance().getOriginalURLKey());
        String refererURL = this.getRefererURL();
        if (!TextUtils.stringSet((String)this.os_destination) && TextUtils.stringSet((String)refererURL)) {
            ServletActionContext.getContext().getSession().put(SecurityConfigFactory.getInstance().getOriginalURLKey(), refererURL);
        }
        return "success";
    }

    private String getRefererURL() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String referer = request.getHeader("Referer");
        if (!TextUtils.stringSet((String)referer)) {
            return null;
        }
        if (referer.indexOf("logout") > -1 || referer.indexOf("login") > -1) {
            return null;
        }
        String result = null;
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (referer.indexOf("://") != -1 && referer.startsWith(baseUrl) && !(result = referer.substring(baseUrl.length())).startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    public boolean isPermitted() {
        return true;
    }

    public boolean isFromNotPermitted() {
        return this.fromNotPermitted;
    }

    public void setFromNotPermitted(boolean fromNotPermitted) {
        this.fromNotPermitted = fromNotPermitted;
    }

    public FieldMethodizer getLoginFilter() {
        return new FieldMethodizer((Object)new LoginFilter());
    }

    public WebRequestUtils getWebRequestUtils() {
        return new WebRequestUtils();
    }

    public String getOs_username() {
        return this.os_username;
    }

    public void setOs_username(String os_username) {
        this.os_username = os_username;
    }

    public String getOs_destination() {
        return this.os_destination;
    }

    public void setOs_destination(String os_destination) {
        this.os_destination = os_destination;
    }

    public boolean isRedirectAfterPost() {
        return this.redirectAfterPost;
    }

    public boolean isShowSignUp() {
        return this.upgradeManager.isUpgraded() && !this.settingsManager.getGlobalSettings().isDenyPublicSignup();
    }

    public boolean isShowForgottenPasswordHelp() {
        return this.upgradeManager.isUpgraded() && !this.settingsManager.getGlobalSettings().isExternalUserManagement();
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }
}

