/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.security.ExternalUserManagementAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserContentManager;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import java.util.List;

public class RemoveUserAction
extends AbstractUsersAction
implements ExternalUserManagementAware {
    private SpaceManager spaceManager;
    private List userOwnedSpaces;
    private List userCommentedSpaces;
    private List userEditedSpaces;
    private UserContentManager userContentManager;

    public String execute() throws Exception {
        Space personalSpace = this.spaceManager.getPersonalSpace(this.user);
        if (personalSpace != null) {
            this.spaceManager.removeSpace(personalSpace);
        }
        if (this.permissionManager.hasPermission(this.getRemoteUser(), Permission.REMOVE, this.getUser())) {
            this.userAccessor.removeUser(this.getUser());
        }
        return "success";
    }

    public void setUserContentManager(UserContentManager userContentManager) {
        this.userContentManager = userContentManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public boolean isUserRemovable() {
        if (this.getUsername() == null || this.getUser() == null) {
            return true;
        }
        return !this.userContentManager.hasAuthoredContent(this.getUser());
    }

    public boolean hasPersonalSpace() {
        return this.spaceManager.getPersonalSpace(this.getUser()) != null;
    }

    public List getUserOwnedSpaces() {
        if (this.userOwnedSpaces == null && this.getUser() != null) {
            this.userOwnedSpaces = this.spaceManager.getAuthoredSpacesByUser(this.getUser().getName());
            this.userOwnedSpaces.remove(this.spaceManager.getPersonalSpace(this.user));
        }
        return this.userOwnedSpaces;
    }

    public List getUserEditedSpaces() {
        if (this.userEditedSpaces == null && this.getUser() != null) {
            this.userEditedSpaces = this.spaceManager.getSpacesContainingPagesEditedBy(this.getUser().getName());
            this.userEditedSpaces.remove(this.spaceManager.getPersonalSpace(this.user));
        }
        return this.userEditedSpaces;
    }

    public List getUserCommentedSpaces() {
        if (this.userCommentedSpaces == null && this.getUser() != null) {
            this.userCommentedSpaces = this.spaceManager.getSpacesContainingCommentsBy(this.getUser().getName());
            this.userCommentedSpaces.remove(this.spaceManager.getPersonalSpace(this.user));
        }
        return this.userCommentedSpaces;
    }
}

