/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.user.SearchEntitiesManager;
import com.atlassian.confluence.user.actions.AbstractEntityPaginationAction;
import com.atlassian.core.util.PairType;
import com.atlassian.user.EntityException;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SearchUsersAction
extends AbstractEntityPaginationAction {
    private static final Logger log = Logger.getLogger(SearchUsersAction.class);
    private List resultsPerPageOptions;
    protected SearchEntitiesManager searchEntitiesManager;
    protected String usernameTerm;
    protected String fullnameTerm;
    protected String emailTerm;
    protected String operator = "match all";
    protected int resultsPerPage = PaginationSupport.DEFAULT_COUNT_ON_EACH_PAGE;

    public SearchUsersAction() {
        this.paginationSupport.setItems(Collections.EMPTY_LIST);
    }

    public void validate() {
        if (StringUtils.isEmpty((String)this.usernameTerm) && StringUtils.isEmpty((String)this.fullnameTerm) && StringUtils.isEmpty((String)this.emailTerm)) {
            this.addActionError(this.getText("must.specify.search.term"));
        }
        super.validate();
    }

    public List getOperators() {
        ArrayList<String> ops = new ArrayList<String>();
        ops.add("match any");
        ops.add("match all");
        return ops;
    }

    public String doUserSearch() {
        ArrayList<TermQuery> searchTerms = new ArrayList<TermQuery>();
        try {
            if (TextUtils.stringSet((String)this.usernameTerm)) {
                this.usernameTerm = this.appendWildcard(this.usernameTerm);
                searchTerms.add(this.searchEntitiesManager.getTermQuery(this.usernameTerm, UserNameTermQuery.class));
            }
            if (TextUtils.stringSet((String)this.fullnameTerm)) {
                this.fullnameTerm = this.appendWildcard(this.fullnameTerm);
                searchTerms.add(this.searchEntitiesManager.getTermQuery(this.fullnameTerm, FullNameTermQuery.class));
            }
            if (TextUtils.stringSet((String)this.emailTerm)) {
                this.emailTerm = this.appendWildcard(this.emailTerm);
                searchTerms.add(this.searchEntitiesManager.getTermQuery(this.emailTerm, EmailTermQuery.class));
            }
        }
        catch (EntityQueryException e) {
            this.addActionError(e.getMessage());
            log.error((Object)e);
            return "error";
        }
        try {
            Query finalQuery = this.searchEntitiesManager.createUserQuery(searchTerms, this.operator);
            List result = this.searchEntitiesManager.findUsersAsList(finalQuery);
            this.paginationSupport.setItems(result);
        }
        catch (EntityException e) {
            this.addActionError(e.getMessage());
            log.error((Object)e);
            return "error";
        }
        catch (IllegalArgumentException iae) {
            this.addActionError(this.getText("must.specify.search.term"));
            log.error((Object)iae);
            return "error";
        }
        return "success";
    }

    private String appendWildcard(String s) {
        if (!s.endsWith("*")) {
            s = s + "*";
        }
        return s;
    }

    public String getUsernameTerm() {
        return this.usernameTerm;
    }

    public void setUsernameTerm(String usernameTerm) {
        this.usernameTerm = usernameTerm;
    }

    public String getFullnameTerm() {
        return this.fullnameTerm;
    }

    public void setFullnameTerm(String fullnameTerm) {
        this.fullnameTerm = fullnameTerm;
    }

    public String getEmailTerm() {
        return this.emailTerm;
    }

    public void setEmailTerm(String emailTerm) {
        this.emailTerm = emailTerm;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setSearchEntitiesManager(SearchEntitiesManager searchEntitiesManager) {
        this.searchEntitiesManager = searchEntitiesManager;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public void setResultsPerPage(int resultsPerPage) {
        if (resultsPerPage >= 0 && resultsPerPage <= 100) {
            this.paginationSupport.setPageSize(resultsPerPage);
            this.resultsPerPage = resultsPerPage;
        }
    }

    public List getResultsPerPageOptions() {
        this.resultsPerPageOptions = new ArrayList();
        this.newResultsPerPageOption(10);
        this.newResultsPerPageOption(20);
        this.newResultsPerPageOption(50);
        this.newResultsPerPageOption(100);
        return this.resultsPerPageOptions;
    }

    private void newResultsPerPageOption(int size) {
        Integer option = new Integer(size);
        this.resultsPerPageOptions.add(new PairType((Serializable)option, (Serializable)((Object)option.toString())));
    }
}

