/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewMyDraftsAction
extends AbstractUserProfileAction {
    private DraftManager draftManager;
    private String discardDraftId;

    public String execute() throws Exception {
        if (TextUtils.stringSet((String)this.getDiscardDraftId())) {
            this.draftManager.removeDraftById(Long.parseLong(this.getDiscardDraftId()));
        }
        return super.execute();
    }

    public List<Draft> getDrafts() {
        return this.draftManager.findDraftsForUser(this.getRemoteUser());
    }

    public String getResumeEditingUrlForDraft(Draft draft) {
        return this.getUrlForDraft(draft, "useDraft=true");
    }

    public String getViewConflictUrlForDraft(Draft draft) {
        return this.getUrlForDraft(draft, "viewConflict=true");
    }

    private String getUrlForDraft(Draft draft, String parameters) {
        if (draft == null) {
            return null;
        }
        if (draft.isNewPage()) {
            return ServletActionContext.getRequest().getContextPath() + "/pages/create" + draft.getDraftType() + ".action?" + parameters + "&spaceKey=" + draft.getDraftSpaceKey();
        }
        return ServletActionContext.getRequest().getContextPath() + "/pages/edit" + draft.getDraftType() + ".action?" + parameters + "&pageId=" + draft.getPageId() + "&spaceKey=" + draft.getDraftSpaceKey();
    }

    public void setDraftManager(DraftManager draftManager) {
        this.draftManager = draftManager;
    }

    public DraftManager getDraftManager() {
        return this.draftManager;
    }

    public String getDiscardDraftId() {
        return this.discardDraftId;
    }

    public void setDiscardDraftId(String discardDraftId) {
        this.discardDraftId = discardDraftId;
    }
}

