/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.SpaceComparator;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewUserProfileAction
extends AbstractUserProfileAction {
    private static final Logger log = Logger.getLogger(ViewUserProfileAction.class);
    private WikiStyleRenderer wikiStyleRenderer;
    private PageManager pageManager;
    private ContentEntityManager contentEntityManager;
    private String username;
    private List recentlyUpdatedContent;
    private List favouriteSpaces;
    private static final int MAX_RECENTLY_UPDATED_CONTENT = 20;

    public boolean isPermitted() {
        if (!super.isPermitted()) {
            return false;
        }
        if (this.settingsManager.getGlobalSettings().isSharedMode()) {
            boolean permitted = false;
            Pager groups = this.userAccessor.getGroups(this.userAccessor.getUser(this.username));
            User currentUser = this.getRemoteUser();
            for (Group group : groups) {
                if (!this.userAccessor.hasMembership(group, currentUser)) continue;
                permitted = true;
            }
            if (GeneralUtil.isSuperUser(currentUser)) {
                permitted = true;
            }
            return permitted;
        }
        return true;
    }

    public String execute() throws Exception {
        if (this.getUser() == null) {
            return "pagenotfound";
        }
        if (this.getPersonalInformationEntity() != null) {
            this.addToHistory(this.getPersonalInformationEntity());
        }
        return super.execute();
    }

    public String getPathToProfilePicture() {
        String filename = this.getUserPreferences().getString("confluence.user.profile.picture");
        if (this.getPersonalInformationEntity() != null) {
            for (Attachment attachment : this.getPersonalInformationEntity().getAttachments()) {
                if (!attachment.getFileName().equals(filename)) continue;
                return attachment.getDownloadPathWithoutVersion();
            }
        }
        return null;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public String getUsername() {
        if ((this.username == null || StringUtils.isEmpty((String)this.username)) && this.getRemoteUser() != null) {
            this.username = this.getRemoteUser().getName();
        }
        return this.username;
    }

    public void setUsername(String username) {
        if (GeneralUtil.shouldUrlDecode(username)) {
            username = GeneralUtil.urlDecode(username);
        }
        this.username = username;
    }

    public String getXHtmlPersonalInformation() {
        String pi = this.getPersonalInformation();
        if (pi == null) {
            return null;
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)this.getPersonalInformationEntity().toPageContext(), pi);
    }

    public Date getSignupDate() {
        try {
            return this.getDateProperty("confluence.user.signup.date");
        }
        catch (Exception e) {
            log.warn((Object)("An error occurred trying to retrieve signup date: " + e), (Throwable)e);
            return null;
        }
    }

    public Date getLastLoginDate() {
        try {
            return this.getDateProperty("confluence.user.previous.login.date");
        }
        catch (Exception e) {
            log.warn((Object)("An error occurred trying to retrieve last login date: " + e), (Throwable)e);
            return null;
        }
    }

    private Date getDateProperty(String propertyKey) {
        PropertySet propertySet = this.userAccessor.getPropertySet(this.getUser());
        if (propertySet.exists(propertyKey)) {
            try {
                long aLong = propertySet.getLong(propertyKey);
                if (aLong > 0L) {
                    return new Date(aLong);
                }
                return propertySet.getDate(propertyKey);
            }
            catch (PropertyException e) {
                return propertySet.getDate(propertyKey);
            }
        }
        return null;
    }

    public int getAuthoredPagesCount() {
        return this.pageManager.getAuthoredPagesCountByUser(this.username);
    }

    public List getRecentlyUpdatedContent() {
        if (this.recentlyUpdatedContent == null) {
            ArrayList<1> criteria = new ArrayList<1>(1);
            criteria.add(new PermissionManager.Criterion(){

                public boolean test(List alreadyChosenEntities, Object entity) {
                    if (entity instanceof ContentEntityObject) {
                        ContentEntityObject ceo = (ContentEntityObject)entity;
                        long ceoId = ((ContentEntityObject)ceo.getLatestVersion()).getId();
                        for (ContentEntityObject ceo2 : alreadyChosenEntities) {
                            long ceo2Id = ((ContentEntityObject)ceo2.getLatestVersion()).getId();
                            if (ceoId != ceo2Id) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            this.recentlyUpdatedContent = this.getPermittedEntitiesOf(this.contentEntityManager.getRecentlyModifiedEntitiesForUser(this.username), 20, criteria);
        }
        return this.recentlyUpdatedContent;
    }

    public List getAuthoredSpaces() {
        return this.getPermittedEntitiesOf(this.spaceManager.getAuthoredSpacesByUser(this.username));
    }

    public boolean isEmailVisible() {
        return this.isMyProfile() || super.isEmailVisible();
    }

    public String renderEmail(String email) {
        return GeneralUtil.maskEmail(email);
    }

    public List getFavouriteSpaces() {
        if (this.favouriteSpaces == null) {
            this.favouriteSpaces = AuthenticatedUserThreadLocal.getUser() == null ? Collections.EMPTY_LIST : this.getPermittedEntitiesOf(this.labelManager.getFavouriteSpaces(this.getRemoteUser().getName()));
            Collections.sort(this.favouriteSpaces, new SpaceComparator());
        }
        return this.favouriteSpaces;
    }
}

