/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.listeners;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.security.RpcAuthenticatedEvent;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserConfigurationChecker;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DelegationAccessor;
import org.dom4j.DocumentException;

public class PersonalInformationCreateListener
implements EventListener {
    private static Boolean standardUserConfiguration = null;
    private DelegationAccessor delegationAccessor;
    private PersonalInformationManager personalInformationManager;
    private UserAccessor userAccessor;

    public Class[] getHandledEventClasses() {
        return new Class[]{LoginEvent.class, RpcAuthenticatedEvent.class};
    }

    public void handleEvent(Event event) {
        if (this.isStandardUserConfiguration()) {
            return;
        }
        User user = null;
        if (event instanceof LoginEvent) {
            LoginEvent loginEvent = (LoginEvent)event;
            user = this.userAccessor.getUser(loginEvent.getUsername());
        } else if (event instanceof RpcAuthenticatedEvent) {
            user = ((RpcAuthenticatedEvent)event).getUser();
        }
        if (user == null) {
            return;
        }
        this.personalInformationManager.createPersonalInformation(user);
    }

    public boolean isStandardUserConfiguration() {
        if (standardUserConfiguration == null) {
            try {
                standardUserConfiguration = UserConfigurationChecker.isStandardOsUser() && UserConfigurationChecker.isStandardAtlassianUser(this.delegationAccessor);
            }
            catch (ConfigurationException ex) {
                standardUserConfiguration = false;
            }
            catch (DocumentException ex) {
                standardUserConfiguration = false;
            }
        }
        return standardUserConfiguration;
    }

    public void setDelegationAccessor(DelegationAccessor delegationAccessor) {
        this.delegationAccessor = delegationAccessor;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

