/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.listeners;

import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.spring.container.ContainerManager;
import java.security.Principal;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Category;

public class UserSessionExpiryListener
implements HttpSessionListener {
    public static final Category log = Category.getInstance(UserSessionExpiryListener.class);
    private volatile EventManager eventManager;
    private volatile boolean serverSupportsSessionAccess = true;

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        block4: {
            if (!this.serverSupportsSessionAccess) {
                return;
            }
            try {
                Principal user = (Principal)event.getSession().getAttribute("seraph_defaultauthenticator_user");
                if (user != null) {
                    this.getEventManager().publishEvent((Event)new LogoutEvent(this, user.getName(), event.getSession().getId()));
                }
            }
            catch (IllegalStateException e) {
                if (!this.serverSupportsSessionAccess) break block4;
                log.info((Object)"Application server does not give us access to expired sessions. Listeners that depend on receiving LogoutEvent will not be reliable.");
                this.serverSupportsSessionAccess = false;
            }
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    private EventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = (EventManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"eventManager");
        }
        return this.eventManager;
    }
}

